/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.redis.module;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import dev.voidframework.redis.exception.RedisException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Singleton
public class JedisResourceProvider
implements Provider<Jedis> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JedisResourceProvider.class);
    private static final String CONFIGURATION_KEY_CONNECTION_POOL_MINIMUM_IDLE = "voidframework.redis.connPool.minimumIdle";
    private static final String CONFIGURATION_KEY_CONNECTION_POOL_MAXIMUM_IDLE = "voidframework.redis.connPool.maximumIdle";
    private static final String CONFIGURATION_KEY_CONNECTION_POOL_MAXIMUM_SIZE = "voidframework.redis.connPool.maximumPoolSize";
    private static final String CONFIGURATION_KEY_CONNECTION_POOL_CONNECTION_TIMEOUT = "voidframework.redis.connPool.connectionTimeout";
    private static final String CONFIGURATION_KEY_CONNECTION_POOL_MAXIMUM_WAIT = "voidframework.redis.connPool.maximumWait";
    private static final String CONFIGURATION_KEY_HOST = "voidframework.redis.host";
    private static final String CONFIGURATION_KEY_PORT = "voidframework.redis.port";
    private static final String CONFIGURATION_KEY_PASSWORD = "voidframework.redis.password";
    private final Config configuration;
    private JedisPool jedisPool;

    @Inject
    public JedisResourceProvider(Config configuration) {
        this.configuration = configuration;
    }

    public Jedis get() {
        if (this.jedisPool == null) {
            int poolMinIdle = this.configuration.getInt(CONFIGURATION_KEY_CONNECTION_POOL_MINIMUM_IDLE);
            int poolMaxIdle = this.configuration.getInt(CONFIGURATION_KEY_CONNECTION_POOL_MAXIMUM_IDLE);
            int poolMaxTotal = this.configuration.getInt(CONFIGURATION_KEY_CONNECTION_POOL_MAXIMUM_SIZE);
            long connectionTimeout = this.configuration.getDuration(CONFIGURATION_KEY_CONNECTION_POOL_CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
            Duration maximumWait = this.configuration.getDuration(CONFIGURATION_KEY_CONNECTION_POOL_MAXIMUM_WAIT);
            String host = this.configuration.getString(CONFIGURATION_KEY_HOST);
            int port = this.configuration.getInt(CONFIGURATION_KEY_PORT);
            String password = this.configuration.getString(CONFIGURATION_KEY_PASSWORD);
            if (poolMinIdle < 0) {
                throw new RedisException.InvalidConfiguration(CONFIGURATION_KEY_CONNECTION_POOL_MINIMUM_IDLE);
            }
            if (poolMaxIdle < 0) {
                throw new RedisException.InvalidConfiguration(CONFIGURATION_KEY_CONNECTION_POOL_MAXIMUM_IDLE);
            }
            if (poolMaxTotal < 0) {
                throw new RedisException.InvalidConfiguration(CONFIGURATION_KEY_CONNECTION_POOL_MAXIMUM_SIZE);
            }
            if (poolMinIdle > poolMaxIdle) {
                throw new RedisException.InvalidConfiguration(CONFIGURATION_KEY_CONNECTION_POOL_MINIMUM_IDLE);
            }
            if (poolMaxIdle > poolMaxTotal) {
                throw new RedisException.InvalidConfiguration(CONFIGURATION_KEY_CONNECTION_POOL_MAXIMUM_IDLE);
            }
            if (StringUtils.isBlank((CharSequence)host)) {
                throw new RedisException.InvalidConfiguration(CONFIGURATION_KEY_HOST);
            }
            if (port <= 0 || port > 65535) {
                throw new RedisException.InvalidConfiguration(CONFIGURATION_KEY_PORT);
            }
            if (connectionTimeout <= 0L || connectionTimeout > Integer.MAX_VALUE) {
                throw new RedisException.InvalidConfiguration(CONFIGURATION_KEY_CONNECTION_POOL_CONNECTION_TIMEOUT);
            }
            JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
            jedisPoolConfig.setMinIdle(poolMinIdle);
            jedisPoolConfig.setMaxIdle(poolMaxIdle);
            jedisPoolConfig.setMaxTotal(poolMaxTotal);
            jedisPoolConfig.setMaxWait(maximumWait);
            this.jedisPool = StringUtils.isNotBlank((CharSequence)password) ? new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port, (int)connectionTimeout, password) : new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port, (int)connectionTimeout);
            LOGGER.info("Redis connected to redis://{}:{}", (Object)host, (Object)port);
        }
        return this.jedisPool.getResource();
    }
}

