/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.test.annotation;

import com.google.inject.Injector;
import com.google.inject.Module;
import dev.voidframework.core.VoidApplication;
import dev.voidframework.test.annotation.ExtraGuiceModule;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class VoidFrameworkJUnitExtension
implements TestInstancePostProcessor {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"dev", "voidframework", "junit5"});

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Injector injector = this.getOrCreateInjector(context);
        Assertions.assertNotNull((Object)injector);
        ExtraGuiceModule extraGuiceModule = testInstance.getClass().getAnnotation(ExtraGuiceModule.class);
        if (extraGuiceModule != null) {
            ArrayList<Module> moduleList = new ArrayList<Module>();
            for (Class<? extends Module> moduleClassType : extraGuiceModule.value()) {
                Module module = moduleClassType.getConstructor(new Class[0]).newInstance(new Object[0]);
                moduleList.add(module);
            }
            injector = injector.createChildInjector(moduleList);
        }
        injector.injectMembers(testInstance);
    }

    private Injector getOrCreateInjector(ExtensionContext context) {
        if (context.getElement().isEmpty()) {
            return null;
        }
        AnnotatedElement element = (AnnotatedElement)context.getElement().get();
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        Injector injector = (Injector)store.get((Object)element, Injector.class);
        if (injector == null) {
            VoidApplication voidApplication = new VoidApplication();
            voidApplication.launch();
            injector = (Injector)voidApplication.getInstance(Injector.class);
            store.put((Object)NAMESPACE, (Object)injector);
        }
        return injector;
    }
}

