/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.http;

import com.fasterxml.jackson.databind.JsonNode;
import dev.voidframework.core.helper.Json;
import dev.voidframework.core.helper.Reflection;
import dev.voidframework.core.helper.Xml;
import dev.voidframework.core.helper.Yaml;
import dev.voidframework.web.http.FormItem;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public record HttpRequestBodyContent(String contentType, byte[] asRaw, Map<String, List<FormItem>> asFormData) {
    public <OUTPUT_CLASS_TYPE> OUTPUT_CLASS_TYPE asFormData(Class<OUTPUT_CLASS_TYPE> outputClass) {
        HashMap<String, String> flatValueMap = new HashMap<String, String>();
        HashMap<String, InputStream> flatFileMap = new HashMap<String, InputStream>();
        for (Map.Entry<String, List<FormItem>> entry : this.asFormData.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            if (!entry.getValue().get(0).isFile()) {
                flatValueMap.put(entry.getKey(), entry.getValue().get(0).value());
                continue;
            }
            flatFileMap.put(entry.getKey(), entry.getValue().get(0).inputStream());
        }
        Object output = Json.fromMap(flatValueMap, outputClass);
        for (Map.Entry entry : flatFileMap.entrySet()) {
            Reflection.setFieldValue((Object)output, (String)((String)entry.getKey()), entry.getValue());
        }
        return (OUTPUT_CLASS_TYPE)output;
    }

    public JsonNode asJson() {
        return Json.toJson((byte[])this.asRaw);
    }

    public <OUTPUT_CLASS_TYPE> OUTPUT_CLASS_TYPE asJson(Class<OUTPUT_CLASS_TYPE> outputClass) {
        return (OUTPUT_CLASS_TYPE)Json.fromJson((JsonNode)this.asJson(), outputClass);
    }

    public Document asXml() {
        return Xml.toXml((byte[])this.asRaw);
    }

    public JsonNode asYaml() {
        return Yaml.toYaml((byte[])this.asRaw);
    }

    public <OUTPUT_CLASS_TYPE> OUTPUT_CLASS_TYPE asYaml(Class<OUTPUT_CLASS_TYPE> outputClass) {
        return (OUTPUT_CLASS_TYPE)Yaml.fromYaml((JsonNode)this.asYaml(), outputClass);
    }
}

