/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.typesafe.config.Config;
import dev.voidframework.core.helper.Json;
import dev.voidframework.template.TemplateRenderer;
import dev.voidframework.template.exception.TemplateException;
import dev.voidframework.web.http.Context;
import dev.voidframework.web.http.Cookie;
import dev.voidframework.web.http.TemplateResult;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class Result {
    private static final NoContentResultProcessor NO_CONTENT_RESULT_PROCESSOR = new NoContentResultProcessor();
    private final int httpCode;
    private final String contentType;
    private final ResultProcessor resultProcessor;
    private final Map<String, String> headerMap;
    private final Map<String, Cookie> cookieMap;

    private Result(int httpCode, ResultProcessor resultProcessor, String contentType) {
        this.httpCode = httpCode;
        this.resultProcessor = resultProcessor;
        this.contentType = contentType;
        this.headerMap = new HashMap<String, String>();
        this.cookieMap = new HashMap<String, Cookie>();
    }

    public static Result badRequest(String content) {
        return new Result(400, new ObjectResultProcessor(content), "text/html");
    }

    public static Result badRequest(byte[] content, String contentType) {
        return new Result(400, new ObjectResultProcessor(content), contentType);
    }

    public static Result badRequest(JsonNode content) {
        return new Result(400, new ObjectResultProcessor(Json.toString((JsonNode)content)), "application/json");
    }

    public static Result badRequest(TemplateResult templateResult) {
        return new Result(400, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result created(String content) {
        return new Result(201, new ObjectResultProcessor(content), "text/html");
    }

    public static Result created(byte[] content, String contentType) {
        return new Result(201, new ObjectResultProcessor(content), contentType);
    }

    public static Result created(JsonNode content) {
        return new Result(201, new ObjectResultProcessor(Json.toString((JsonNode)content)), "application/json");
    }

    public static Result created(TemplateResult templateResult) {
        return new Result(201, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result forbidden(String content) {
        return new Result(403, new ObjectResultProcessor(content), "text/html");
    }

    public static Result forbidden(byte[] content, String contentType) {
        return new Result(403, new ObjectResultProcessor(content), contentType);
    }

    public static Result forbidden(JsonNode content) {
        return new Result(403, new ObjectResultProcessor(Json.toString((JsonNode)content)), "application/json");
    }

    public static Result forbidden(TemplateResult templateResult) {
        return new Result(403, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result internalServerError(String content) {
        return new Result(500, new ObjectResultProcessor(content), "text/html");
    }

    public static Result internalServerError(byte[] content, String contentType) {
        return new Result(500, new ObjectResultProcessor(content), contentType);
    }

    public static Result internalServerError(JsonNode content) {
        return new Result(500, new ObjectResultProcessor(Json.toString((JsonNode)content)), "application/json");
    }

    public static Result internalServerError(TemplateResult templateResult) {
        return new Result(404, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result noContent() {
        return new Result(204, NO_CONTENT_RESULT_PROCESSOR, null);
    }

    public static Result notFound(String content) {
        return new Result(404, new ObjectResultProcessor(content), "text/html");
    }

    public static Result notFound(byte[] content, String contentType) {
        return new Result(404, new ObjectResultProcessor(content), contentType);
    }

    public static Result notFound(JsonNode content) {
        return new Result(404, new ObjectResultProcessor(Json.toString((JsonNode)content)), "application/json");
    }

    public static Result notFound(TemplateResult templateResult) {
        return new Result(404, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result notImplemented(String content) {
        return new Result(501, new ObjectResultProcessor(content), "text/html");
    }

    public static Result notImplemented(byte[] content, String contentType) {
        return new Result(501, new ObjectResultProcessor(content), contentType);
    }

    public static Result notImplemented(JsonNode content) {
        return new Result(501, new ObjectResultProcessor(Json.toString((JsonNode)content)), "application/json");
    }

    public static Result notImplemented(TemplateResult templateResult) {
        return new Result(501, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result ok(String content) {
        return new Result(200, new ObjectResultProcessor(content), "text/html");
    }

    public static Result ok(byte[] content, String contentType) {
        return new Result(200, new ObjectResultProcessor(content), contentType);
    }

    public static Result ok(InputStream content, String contentType) {
        return new Result(200, new ObjectResultProcessor(content), contentType);
    }

    public static Result ok(JsonNode content) {
        return new Result(200, new ObjectResultProcessor(Json.toString((JsonNode)content)), "application/json");
    }

    public static Result ok(TemplateResult templateResult) {
        return new Result(200, new TemplateResultProcessor(templateResult.templateName, templateResult.dataModel), "text/html");
    }

    public static Result redirectPermanentlyTo(String uri) {
        return new Result(301, NO_CONTENT_RESULT_PROCESSOR, null).withHeader("Location", uri);
    }

    public static Result redirectTemporaryTo(String uri) {
        return new Result(302, NO_CONTENT_RESULT_PROCESSOR, null).withHeader("Location", uri);
    }

    public Result withCookie(Cookie cookie) {
        this.cookieMap.put(cookie.name(), cookie);
        return this;
    }

    public Result withoutCookie(Cookie cookie) {
        return this.withoutCookie(cookie.name());
    }

    public Result withoutCookie(String cookieName) {
        this.cookieMap.put(cookieName, Cookie.expired(cookieName));
        return this;
    }

    public Result withHeader(String headerName, String value) {
        this.headerMap.put(headerName, value);
        return this;
    }

    public Result withoutHeader(String headerName) {
        this.headerMap.remove(headerName);
        return this;
    }

    public Map<String, Cookie> getCookies() {
        return this.cookieMap;
    }

    public Map<String, String> getHeaders() {
        return this.headerMap;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ResultProcessor getResultProcessor() {
        return this.resultProcessor;
    }

    public static interface ResultProcessor {
        public void process(Context var1, Config var2, TemplateRenderer var3);

        public InputStream getInputStream();
    }

    private static class ObjectResultProcessor
    implements ResultProcessor {
        private final Object object;

        public ObjectResultProcessor(Object object) {
            this.object = object;
        }

        @Override
        public void process(Context context, Config configuration, TemplateRenderer templateRenderer) {
        }

        @Override
        public InputStream getInputStream() {
            if (this.object == null) {
                return ByteArrayInputStream.nullInputStream();
            }
            if (this.object instanceof byte[]) {
                return new ByteArrayInputStream((byte[])this.object);
            }
            if (this.object instanceof InputStream) {
                return (InputStream)this.object;
            }
            return new ByteArrayInputStream(this.object.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    private static class TemplateResultProcessor
    implements ResultProcessor {
        private final String templateName;
        private final Map<String, Object> dataModel;
        private InputStream inputStream;

        public TemplateResultProcessor(String templateName, Map<String, Object> dataModel) {
            this.templateName = templateName;
            this.dataModel = dataModel;
            this.inputStream = null;
        }

        @Override
        public void process(Context context, Config configuration, TemplateRenderer templateRenderer) {
            if (templateRenderer == null) {
                throw new TemplateException.NoTemplateEngine();
            }
            this.dataModel.put("flash", context.getFlashMessages());
            this.dataModel.put("session", context.getSession());
            this.dataModel.put("languages", configuration.getStringList("voidframework.web.language.availableLanguages"));
            String renderedTemplate = templateRenderer.render(this.templateName, context.getLocale(), this.dataModel);
            this.inputStream = new ByteArrayInputStream(renderedTemplate.getBytes(StandardCharsets.UTF_8));
            context.getFlashMessages().clear();
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }
    }

    private static class NoContentResultProcessor
    implements ResultProcessor {
        private NoContentResultProcessor() {
        }

        @Override
        public void process(Context context, Config configuration, TemplateRenderer templateRenderer) {
        }

        @Override
        public InputStream getInputStream() {
            return null;
        }
    }
}

