/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.http.impl;

import com.google.inject.Inject;
import com.typesafe.config.Config;
import dev.voidframework.core.bindable.BindClass;
import dev.voidframework.template.exception.TemplateException;
import dev.voidframework.web.exception.HttpException;
import dev.voidframework.web.http.Context;
import dev.voidframework.web.http.ErrorHandler;
import dev.voidframework.web.http.Result;
import dev.voidframework.web.http.errorpage.DevMode400BadRequest;
import dev.voidframework.web.http.errorpage.DevMode404NotFound;
import dev.voidframework.web.http.errorpage.DevMode500InternalServerError;
import dev.voidframework.web.routing.Router;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BindClass
public class DefaultErrorHandler
implements ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandler.class);
    private final Config configuration;
    private final Router router;

    @Inject
    public DefaultErrorHandler(Config configuration, Router router) {
        this.configuration = configuration;
        this.router = router;
    }

    @Override
    public Result onBadRequest(Context context, HttpException.BadRequest badRequestException) {
        if (this.configuration.getBoolean("voidframework.core.runInDevMode")) {
            HttpException.BadRequest cause = badRequestException == null || badRequestException.getCause() == null ? badRequestException : badRequestException.getCause();
            String errorMessage = cause == null ? null : cause.getMessage();
            return Result.badRequest(DevMode400BadRequest.render(errorMessage));
        }
        return Result.badRequest("400 Bad Request");
    }

    @Override
    public Result onNotFound(Context context, HttpException.NotFound notFoundException) {
        if (this.configuration.getBoolean("voidframework.core.runInDevMode")) {
            return Result.notFound(DevMode404NotFound.render(context.getRequest().getHttpMethod(), context.getRequest().getRequestURI(), this.router.getRoutesAsList()));
        }
        return Result.notFound("404 Not Found");
    }

    @Override
    public Result onServerError(Context context, Throwable throwable) {
        LOGGER.error("Something goes wrong", throwable);
        if (this.configuration.getBoolean("voidframework.core.runInDevMode")) {
            List fileLineList;
            Object subHeaderError;
            int lineNumberFromZero;
            Throwable cause;
            Throwable throwable2 = cause = throwable.getCause() == null ? throwable : throwable.getCause();
            if (throwable.getClass() == TemplateException.RenderingFailure.class) {
                TemplateException.RenderingFailure renderingFailure = (TemplateException.RenderingFailure)throwable;
                Optional<Path> javaFilepathOptional = this.resolvePossibleTemplateFileLocation(renderingFailure.getTemplateName());
                lineNumberFromZero = renderingFailure.getLineNumber();
                subHeaderError = javaFilepathOptional.map(Path::toString).orElse(renderingFailure.getTemplateName()) + ":" + lineNumberFromZero;
                fileLineList = javaFilepathOptional.map(path -> this.retrievePartialFileContent((Path)path, lineNumberFromZero)).orElseGet(ArrayList::new);
                if (cause.getCause() != null) {
                    cause = cause.getCause();
                }
            } else {
                StackTraceElement stackTraceElement = cause.getStackTrace()[0];
                subHeaderError = stackTraceElement.toString();
                lineNumberFromZero = stackTraceElement.getLineNumber() - 1;
                String javaFileName = stackTraceElement.getClassName().replace(".", File.separator).split("\\$", 2)[0] + ".java";
                Optional<Path> javaFilepathOptional = this.resolvePossibleJavaFileLocation(javaFileName);
                fileLineList = javaFilepathOptional.map(path -> this.retrievePartialFileContent((Path)path, lineNumberFromZero)).orElseGet(ArrayList::new);
            }
            return Result.internalServerError(DevMode500InternalServerError.render(cause.getMessage() != null ? cause.getMessage() : "Oops, something goes wrong", (String)subHeaderError, lineNumberFromZero, fileLineList));
        }
        return Result.internalServerError("500 Internal Server Error");
    }

    private Optional<Path> resolvePossibleJavaFileLocation(String javaFileName) {
        Optional<Path> optional;
        block9: {
            Path rootPath = Paths.get(System.getProperty("user.dir"), new String[0]);
            Path resolvePath = Path.of("src", "main", "java", javaFileName);
            Path firstPossibleLocation = rootPath.resolve(resolvePath);
            if (firstPossibleLocation.toFile().exists()) {
                return Optional.of(firstPossibleLocation);
            }
            Stream<Path> stream = Files.walk(rootPath, 1, new FileVisitOption[0]);
            try {
                optional = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(path -> path.resolve(resolvePath)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignore) {
                    return Optional.empty();
                }
            }
            stream.close();
        }
        return optional;
    }

    private Optional<Path> resolvePossibleTemplateFileLocation(String templateFileName) {
        Optional<Path> optional;
        block9: {
            Path rootPath = Paths.get(System.getProperty("user.dir"), new String[0]);
            Path resolvePath = Path.of("src", "main", "resources", "views", templateFileName);
            Path firstPossibleLocation = rootPath.resolve(resolvePath);
            if (firstPossibleLocation.toFile().exists()) {
                return Optional.of(firstPossibleLocation);
            }
            Stream<Path> stream = Files.walk(rootPath, 1, new FileVisitOption[0]);
            try {
                optional = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(path -> path.resolve(resolvePath)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignore) {
                    return Optional.empty();
                }
            }
            stream.close();
        }
        return optional;
    }

    private List<FileLine> retrievePartialFileContent(Path javaFilePath, int requestedLineNumber) {
        int cleanedLineNumberFrom = Math.max(requestedLineNumber - 6, 0);
        int cleanedLineNumberTo = Math.max(cleanedLineNumberFrom, requestedLineNumber + 7);
        ArrayList<FileLine> fileLineList = new ArrayList<FileLine>();
        try {
            List<String> readlineList = Files.readAllLines(javaFilePath);
            for (int idx = cleanedLineNumberFrom; idx < cleanedLineNumberTo && idx < readlineList.size(); ++idx) {
                fileLineList.add(new FileLine(idx, readlineList.get(idx)));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileLineList;
    }

    public record FileLine(int number, String content) {
    }
}

