/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.routing.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dev.voidframework.core.helper.ProxyDetector;
import dev.voidframework.web.exception.RoutingException;
import dev.voidframework.web.filter.Filter;
import dev.voidframework.web.filter.WithFilter;
import dev.voidframework.web.routing.HttpMethod;
import dev.voidframework.web.routing.ResolvedRoute;
import dev.voidframework.web.routing.Route;
import dev.voidframework.web.routing.Router;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRouter
implements Router {
    private static final Logger LOGGER = LoggerFactory.getLogger(Router.class);
    private static final Pattern PATTERN_EXTRACT_REGEXP_GROUP = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z\\d]*)>.*\\)");
    private static final Pattern PATTERN_EXTRACT_REGEXP_GROUP_NAME = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z\\d]*)>");
    private final Map<HttpMethod, List<Route>> routeListPerHttpMethodMap = new HashMap<HttpMethod, List<Route>>();
    private final Map<String, List<Route>> routeListPerNameMap = new HashMap<String, List<Route>>();

    private static Set<String> getNamedGroup(String regex) {
        TreeSet<String> namedGroups = new TreeSet<String>();
        Matcher matcher = PATTERN_EXTRACT_REGEXP_GROUP_NAME.matcher(regex);
        while (matcher.find()) {
            namedGroups.add(matcher.group(1));
        }
        return namedGroups;
    }

    @Override
    public void addRoute(HttpMethod httpMethod, String routeUrl, Class<?> controllerClassType, Method method) {
        this.addRoute(httpMethod, routeUrl, controllerClassType, method, "");
    }

    @Override
    public void addRoute(HttpMethod httpMethod, String routeUrl, Class<?> controllerClassType, Method method, String name) {
        this.checkAddRouteArguments(httpMethod, routeUrl, controllerClassType, method);
        Class<?> controllerClass = ProxyDetector.isProxy(controllerClassType) ? controllerClassType.getSuperclass() : controllerClassType;
        LOGGER.debug("Add route {} {} {}::{}", new Object[]{httpMethod, routeUrl, controllerClass.getName(), method.getName()});
        ArrayList<Class<? extends Filter>> filterClassList = new ArrayList<Class<? extends Filter>>();
        WithFilter withFilter = controllerClass.getAnnotation(WithFilter.class);
        if (withFilter != null) {
            filterClassList.addAll(Arrays.asList(withFilter.value()));
        }
        if ((withFilter = method.getAnnotation(WithFilter.class)) != null) {
            filterClassList.addAll(Arrays.asList(withFilter.value()));
        }
        Route route = new Route(httpMethod, Pattern.compile(routeUrl), filterClassList, controllerClass, method);
        this.routeListPerHttpMethodMap.computeIfAbsent(httpMethod, key -> new ArrayList()).add(route);
        String nameKey = StringUtils.isBlank((CharSequence)name) ? (controllerClass.getName() + "." + method.getName()).replace("$", ".") : name;
        this.routeListPerNameMap.computeIfAbsent(nameKey, key -> new ArrayList()).add(route);
    }

    @Override
    public ResolvedRoute resolveRoute(HttpMethod httpMethod, String uri) {
        if (httpMethod == null || StringUtils.isEmpty((CharSequence)uri)) {
            return null;
        }
        List<Route> routeList = this.routeListPerHttpMethodMap.get((Object)httpMethod);
        if (routeList != null) {
            for (Route route : routeList) {
                Map<String, String> extractedParameterMap;
                Matcher matcher = route.routePattern().matcher(uri);
                if (!matcher.matches()) continue;
                if (route.method().getParameterCount() == 0) {
                    extractedParameterMap = Collections.emptyMap();
                } else {
                    extractedParameterMap = new HashMap();
                    for (String namedGroup : DefaultRouter.getNamedGroup(route.routePattern().pattern())) {
                        extractedParameterMap.put(namedGroup, matcher.group(namedGroup));
                    }
                }
                return new ResolvedRoute(route.filterClassTypes(), route.controllerClassType(), route.method(), extractedParameterMap);
            }
        }
        return null;
    }

    @Override
    public String reverseRoute(String name) {
        return this.reverseRoute(name, Collections.emptyList());
    }

    @Override
    public String reverseRoute(String name, List<Object> parameterList) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        List<Route> routeList = this.routeListPerNameMap.get(name);
        if (routeList == null) {
            return null;
        }
        for (Route route : routeList) {
            Matcher matcher = PATTERN_EXTRACT_REGEXP_GROUP.matcher(route.routePattern().toString());
            Iterator<Object> iterator = parameterList.iterator();
            Object url = "";
            while (matcher.find()) {
                url = matcher.replaceAll(matchResult -> iterator.hasNext() ? Objects.toString(iterator.next()) : "");
            }
            if (((String)url).isEmpty()) {
                url = (String)url + route.routePattern().toString();
            }
            if (!route.routePattern().matcher((CharSequence)url).matches()) continue;
            return url;
        }
        return null;
    }

    @Override
    public List<Route> getRoutesAsList() {
        List routeList = this.routeListPerHttpMethodMap.values().stream().flatMap(Collection::stream).toList();
        return ImmutableList.copyOf(routeList);
    }

    @Override
    public Map<HttpMethod, List<Route>> getRoutesAsMap() {
        return ImmutableMap.copyOf(this.routeListPerHttpMethodMap);
    }

    private void checkAddRouteArguments(HttpMethod httpMethod, String routeUrl, Class<?> controllerClassType, Method method) {
        if (httpMethod == null) {
            throw new RoutingException.BadRoutingArgument("httpMethod", (Object)null);
        }
        if (routeUrl == null || routeUrl.length() != routeUrl.trim().length()) {
            throw new RoutingException.BadRoutingArgument("routeUrl", routeUrl);
        }
        if (controllerClassType == null) {
            throw new RoutingException.BadRoutingArgument("controllerClassType", (Object)null);
        }
        if (method == null) {
            throw new RoutingException.BadRoutingArgument("method", (Object)null);
        }
    }
}

