/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.codegen.pui9.db;

import es.prodevelop.codegen.pui9.enums.EntityTypeEnum;
import es.prodevelop.codegen.pui9.model.Column;
import es.prodevelop.codegen.pui9.model.ColumnVisibility;
import es.prodevelop.codegen.pui9.model.DatabaseColumnType;
import es.prodevelop.codegen.pui9.model.DatabaseType;
import es.prodevelop.codegen.pui9.model.Entity;
import es.prodevelop.codegen.pui9.model.GeometryType;
import es.prodevelop.codegen.pui9.model.Table;
import es.prodevelop.codegen.pui9.model.View;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CodegenModelsDatabaseUtils {
    private static CodegenModelsDatabaseUtils singleton;
    private Connection conn;
    private DatabaseType dbType;
    private Map<String, List<String>> triggersMap = new LinkedHashMap<String, List<String>>();

    public static CodegenModelsDatabaseUtils singleton(Connection conn) {
        singleton = new CodegenModelsDatabaseUtils(conn);
        return singleton;
    }

    public static CodegenModelsDatabaseUtils singleton() {
        if (singleton == null) {
            throw new IllegalStateException("You should call singleton method with Model on first call in order to create the conection");
        }
        return singleton;
    }

    private CodegenModelsDatabaseUtils(Connection conn) {
        this.conn = conn;
        try {
            this.dbType = DatabaseType.getByOfficialName(conn.getMetaData().getDatabaseProductName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean loadTable(Table table) {
        boolean exists = this.modifyRealTableName(table, EntityTypeEnum.TABLE);
        if (!exists) {
            return false;
        }
        this.loadColumns(table);
        this.loadPrimaryKeys(table);
        return true;
    }

    public boolean loadView(View view) {
        boolean exists = this.modifyRealTableName(view, EntityTypeEnum.VIEW);
        if (!exists) {
            return false;
        }
        this.loadColumns(view);
        return true;
    }

    private void loadColumns(Entity entity) {
        try (ResultSet rs = this.conn.getMetaData().getColumns(null, null, entity.getDbName(), "%");){
            ArrayList<String> columns = new ArrayList<String>();
            while (rs.next()) {
                Column column = new Column();
                column.setEntity(entity);
                column.setDbName(rs.getString(ColumnMetadataEnum.COLUMN_NAME.name()));
                column.setDbType(DatabaseColumnType.getByTypeId(rs.getInt(ColumnMetadataEnum.DATA_TYPE.name())));
                if (column.getDbType() == null) continue;
                column.setDbRawType(rs.getString(ColumnMetadataEnum.TYPE_NAME.name()));
                column.setDbDefaultValue(rs.getString(ColumnMetadataEnum.COLUMN_DEF.name()));
                column.setDbSize(rs.getInt(ColumnMetadataEnum.COLUMN_SIZE.name()));
                column.setDbDecimals(rs.getInt(ColumnMetadataEnum.DECIMAL_DIGITS.name()));
                column.setNullable(rs.getInt(ColumnMetadataEnum.NULLABLE.name()) == 1);
                column.setPosition(rs.getInt(ColumnMetadataEnum.ORDINAL_POSITION.name()) - 1);
                column.setPk(false);
                column.setColumnVisibility(ColumnVisibility.visible);
                if (column.getDbName().equalsIgnoreCase("lang")) {
                    column.setColumnVisibility(ColumnVisibility.completelyhidden);
                }
                column.setAutoincrementable(false);
                column.setGeometry(this.dbType.geometryColumnNames.stream().anyMatch(gcm -> column.getDbRawType().contains((CharSequence)gcm)));
                boolean isDbAutoinc = rs.getBoolean(ColumnMetadataEnum.IS_AUTOINCREMENT.name());
                switch (this.dbType) {
                    case ORACLE: {
                        column.setGeometryType(GeometryType.NONE);
                        column.setSequence(isDbAutoinc || this.lookForOracleTriggerForColumn(entity.getDbName(), column.getDbName()));
                        break;
                    }
                    case POSTGRE_SQL: {
                        if (column.getDbType().equals((Object)DatabaseColumnType.TIMESTAMP) && column.getDbDecimals() == 3) {
                            column.setDbType(DatabaseColumnType.TIMESTAMP_LOCAL_TIMEZONE);
                        }
                        if (column.isGeometry()) {
                            column.setGeometryType(this.lookForGeometryTypePostgresql(entity.getDbName(), column.getDbName()));
                        } else {
                            column.setGeometryType(GeometryType.NONE);
                        }
                        column.setSequence(isDbAutoinc || column.getDbRawType().toLowerCase().contains("serial"));
                        break;
                    }
                    case SQL_SERVER: {
                        if (column.getDbType().equals((Object)DatabaseColumnType.TIMESTAMP)) {
                            if (column.getDbDecimals() == 3) {
                                column.setDbType(DatabaseColumnType.TIMESTAMP_LOCAL_TIMEZONE);
                            } else {
                                column.setDbType(DatabaseColumnType.DATE);
                            }
                        }
                        column.setGeometryType(GeometryType.NONE);
                        column.setSequence(isDbAutoinc || column.getDbRawType().toLowerCase().contains("identity"));
                    }
                }
                entity.addColumn(column);
                columns.add(column.getDbName());
            }
            entity.removeWrongColumns(columns);
            entity.reorderColumns();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private boolean lookForOracleTriggerForColumn(String tableName, String columnName) {
        if (!this.triggersMap.containsKey(tableName)) {
            this.triggersMap.put(tableName, new ArrayList());
            StringBuilder sql = new StringBuilder();
            sql.append("select * ");
            sql.append("from user_triggers ");
            sql.append("where lower(table_name) = lower(?) ");
            try (PreparedStatement stm = this.conn.prepareStatement(sql.toString());){
                stm.setString(1, tableName);
                try (ResultSet rs = stm.executeQuery();){
                    while (rs.next()) {
                        String triggerBody = rs.getString(EntityMetadataEnum.TRIGGER_BODY.name());
                        if (StringUtils.isEmpty((CharSequence)triggerBody)) continue;
                        triggerBody = triggerBody.toLowerCase();
                        triggerBody = triggerBody.replace(System.getProperty("line.separator"), "");
                        triggerBody = triggerBody.trim().replaceAll(" +", " ");
                        this.triggersMap.get(tableName).add(triggerBody);
                    }
                }
            }
            catch (SQLException e) {
                return false;
            }
        }
        for (String triggerBody : this.triggersMap.get(tableName)) {
            if (!triggerBody.contains(".nextval into :new." + columnName.toLowerCase() + " from dual")) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private GeometryType lookForGeometryTypePostgresql(String table, String column) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadPrimaryKeys(Table table) {
        try (ResultSet rs = this.conn.getMetaData().getPrimaryKeys(null, null, table.getDbName());){
            while (rs.next()) {
                table.addPrimaryKeyName(rs.getString(ColumnMetadataEnum.COLUMN_NAME.name()));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private boolean modifyRealTableName(Entity entity, EntityTypeEnum entityType) {
        if (this.existsTable(entity.getDbName(), entityType)) {
            return true;
        }
        if (this.existsTable(entity.getDbName().toLowerCase(), entityType)) {
            entity.setDbName(entity.getDbName().toLowerCase());
            return true;
        }
        if (this.existsTable(entity.getDbName().toUpperCase(), entityType)) {
            entity.setDbName(entity.getDbName().toUpperCase());
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean existsTable(String entityName, EntityTypeEnum entityType) {
        try (ResultSet rs = this.conn.getMetaData().getTables(null, null, entityName, new String[]{entityType.name()});){
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    private static enum ColumnMetadataEnum {
        COLUMN_NAME,
        DATA_TYPE,
        COLUMN_SIZE,
        TYPE_NAME,
        DECIMAL_DIGITS,
        COLUMN_DEF,
        NULLABLE,
        ORDINAL_POSITION,
        IS_AUTOINCREMENT;

    }

    private static enum EntityMetadataEnum {
        TABLE_NAME,
        TRIGGER_BODY;

    }
}

