/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.codegen.pui9.model;

import es.prodevelop.codegen.pui9.model.ClientConfiguration;
import es.prodevelop.codegen.pui9.model.DatabaseConnection;
import es.prodevelop.codegen.pui9.model.ServerConfiguration;
import es.prodevelop.codegen.pui9.model.Table;
import es.prodevelop.codegen.pui9.model.View;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PuiConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient String modelName = "";
    private transient Table selectedTable;
    private transient View selectedView;
    private transient File file;
    private String projectId;
    private String pui9Version;
    private DatabaseConnection database;
    private ServerConfiguration server;
    private ClientConfiguration client;
    private List<Table> tables;
    private List<View> views;

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
        if (!modelName.isEmpty()) {
            this.server.setReadFunctionality("READ_" + modelName.toUpperCase());
            this.server.setWriteFunctionality("WRITE_" + modelName.toUpperCase());
            this.server.setInsertFunctionality("INSERT_" + modelName.toUpperCase());
            this.server.setUpdateFunctionality("UPDATE_" + modelName.toUpperCase());
            this.server.setDeleteFunctionality("DELETE_" + modelName.toUpperCase());
            this.server.setGetFunctionality("GET_" + modelName.toUpperCase());
            this.server.setListFunctionality("LIST_" + modelName.toUpperCase());
        } else {
            this.server.setReadFunctionality("");
            this.server.setWriteFunctionality("");
            this.server.setInsertFunctionality("");
            this.server.setUpdateFunctionality("");
            this.server.setDeleteFunctionality("");
            this.server.setGetFunctionality("");
            this.server.setListFunctionality("");
        }
    }

    public Table getSelectedTable() {
        return this.selectedTable;
    }

    public void setSelectedTable(Table selectedTable) {
        this.selectedTable = selectedTable;
    }

    public View getSelectedView() {
        return this.selectedView;
    }

    public void setSelectedView(View selectedView) {
        this.selectedView = selectedView;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Table findTable(String name) {
        for (Table table : this.tables) {
            if (!table.getDbName().equals(name)) continue;
            return table;
        }
        return null;
    }

    public View findView(String name) {
        for (View view : this.views) {
            if (!view.getDbName().equals(name)) continue;
            return view;
        }
        return null;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getPui9Version() {
        return this.pui9Version;
    }

    public void setPui9Version(String pui9Version) {
        this.pui9Version = pui9Version;
    }

    public DatabaseConnection getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseConnection database) {
        this.database = database;
    }

    public ServerConfiguration getServer() {
        return this.server;
    }

    public void setServer(ServerConfiguration server) {
        this.server = server;
    }

    public ClientConfiguration getClient() {
        return this.client;
    }

    public void setClient(ClientConfiguration client) {
        this.client = client;
    }

    public List<Table> getTables() {
        if (this.tables == null) {
            this.tables = new ArrayList<Table>();
        }
        return this.tables;
    }

    public void addTable(Table table) {
        this.getTables().add(table);
    }

    public void setTables(List<Table> tables) {
        this.tables = tables;
    }

    public List<View> getViews() {
        if (this.views == null) {
            this.views = new ArrayList<View>();
        }
        return this.views;
    }

    public void addView(View view) {
        this.getViews().add(view);
    }

    public void setViews(List<View> views) {
        this.views = views;
    }

    public String toString() {
        return "Project ID: " + this.projectId + "\nPUI9 Version: " + this.pui9Version + "\nDatabase: " + this.database + (this.selectedTable != null ? "\n\nTable:\n" + this.selectedTable : "") + (this.selectedView != null ? "\n\nView:\n" + this.selectedView : "");
    }
}

