package fi.evolver.script;

import java.util.ArrayList;
import java.util.List;

public class TextUtils {
	/**
	 * <p>Adds or updates a script block, replacing existing block contents if found.
	 * The block is delimited with comment strings using the blockId param.</p>
	 * E.g.
	 * <pre>
	 *     #BLOCK-START this-is-a-block-id #####
	 *     export PATH="$PATH:/new-dir"
	 *     #BLOCK-END this-is-a-block-id #####
	 * </pre>
	 *
	 * @param blockId the identifier used for the block
	 * @param blockContent content to write between block start and end markers
	 */
	public static String addShellBlock(String originalContent, String blockId, String blockContent) {
		String startMarker = "#BLOCK-START " + blockId + " #####";
		String endMarker = "#BLOCK-END " + blockId + " #####";

		List<String> updatedLines = new ArrayList<>();
		boolean inBlock = false;
		boolean blockFound = false;

		for (String line : originalContent.split("\n")) {
			if (line.trim().equals(startMarker)) {
				inBlock = true;
				updatedLines.add(startMarker);
				updatedLines.add(blockContent);
				blockFound = true;
				continue;
			}
			if (line.trim().equals(endMarker)) {
				inBlock = false;
				updatedLines.add(endMarker);
				continue;
			}
			if (!inBlock) {
				updatedLines.add(line);
			}
		}

		if (inBlock) {
			throw new IllegalStateException("Block " + blockId + " started but not finished");
		}

		if (!blockFound) {
			updatedLines.add("");
			updatedLines.add(startMarker);
			updatedLines.add(blockContent);
			updatedLines.add(endMarker);
			updatedLines.add("");
		}
		return String.join("\n", updatedLines);
	}
}
