/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.FileUtils;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.app.Apt;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class Chromium {
    private static final String EXTERNAL_EXTENSION_JSON = "{\n\t\"external_update_url\": \"https://clients2.google.com/service/update2/crx\"\n}\n";
    private static final Path CONFIG_DIR = Shell.HOME.resolve(".config/chromium");
    public static final String EXTENSION_REACT_DEVELOPER_TOOLS = "fmkadmapgofadopljbjfkapdkoienihi";
    public static final String EXTENSION_REDUX_DEV_TOOLS = "lmhkpmbekcpmknklioeibfkpmmfibljd";

    public static void install() {
        try (Step step = Step.start("Chromium: Install");){
            Apt.install("chromium");
        }
    }

    public static void addExtensions(List<String> extensionIds) throws IOException {
        try (Step step = Step.start("Chromium: Add extensions");){
            Path externalExtensionsDir = CONFIG_DIR.resolve("External Extensions");
            if (Files.exists(externalExtensionsDir, new LinkOption[0])) {
                step.skip("External extensions already configured");
                return;
            }
            Files.createDirectories(externalExtensionsDir, new FileAttribute[0]);
            for (String extensionId : extensionIds) {
                Path extensionFile = externalExtensionsDir.resolve(extensionId + ".json");
                FileUtils.write(extensionFile, EXTERNAL_EXTENSION_JSON);
            }
        }
    }

    public static void installBookmarks(Path bookmarksSourcePath) throws IOException {
        try (Step step = Step.start("Chromium: Install Bookmarks");){
            Path defaultProfileDir = CONFIG_DIR.resolve("Default");
            Path targetFile = defaultProfileDir.resolve("Bookmarks");
            if (Files.exists(targetFile, new LinkOption[0])) {
                step.skip("Bookmarks already exist");
                return;
            }
            Files.createDirectories(defaultProfileDir, new FileAttribute[0]);
            Files.copy(bookmarksSourcePath, targetFile, new CopyOption[0]);
        }
    }
}

