/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script;

import fi.evolver.script.Shell;
import fi.evolver.script.TextUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;

public final class FileUtils {
    private FileUtils() {
    }

    public static void write(Path path, String content) {
        try {
            Files.writeString(path, (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to file " + String.valueOf(path), e);
        }
    }

    public static void write(Path path, String content, Set<PosixFilePermission> permissions) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.setPosixFilePermissions(path, permissions);
            } else {
                Files.createFile(path, PosixFilePermissions.asFileAttribute(permissions));
            }
            FileUtils.write(path, content);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to file " + String.valueOf(path), e);
        }
    }

    public static void append(Path path, String content) {
        try {
            Files.writeString(path, (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to append to file " + String.valueOf(path), e);
        }
    }

    public static void writeBytes(Path file, byte[] content) {
        try {
            Files.write(file, content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path createTempDir(String prefix) {
        try {
            Path tempFile = Files.createTempDirectory(prefix, new FileAttribute[0]);
            tempFile.toFile().deleteOnExit();
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path createTempFile(String prefix, String suffix) {
        try {
            Path tempFile = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
            tempFile.toFile().deleteOnExit();
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path writeTempFile(String prefix, String suffix, String data) {
        Path tempFile = FileUtils.createTempFile(prefix, suffix);
        FileUtils.write(tempFile, data);
        return tempFile;
    }

    public static Path writeTempFile(String prefix, String suffix, byte[] data) {
        Path tempFile = FileUtils.createTempFile(prefix, suffix);
        FileUtils.writeBytes(tempFile, data);
        return tempFile;
    }

    public static void sudoWrite(String targetPath, String content, String owner, String chmodPerms) {
        Path temp = FileUtils.writeTempFile("temp", ".tmp", content);
        FileUtils.sudoCopy(temp.toString(), targetPath, owner, chmodPerms);
    }

    public static void sudoWrite(String targetPath, byte[] content, String owner, String chmodPerms) {
        Path temp = FileUtils.writeTempFile("temp", ".tmp", content);
        FileUtils.sudoCopy(temp.toString(), targetPath, owner, chmodPerms);
    }

    public static void sudoCopy(String sourcePath, String targetPath, String owner, String chmodPerms) {
        Shell.sudo("cp", sourcePath, targetPath);
        Shell.sudo("chown", owner, targetPath);
        Shell.sudo("chmod", chmodPerms, targetPath);
    }

    public static void copy(Path source, Path target) {
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy file from %s to %s".formatted(source, target), e);
        }
    }

    public static void copy(Path source, Path target, Set<PosixFilePermission> permissions) {
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
            Files.setPosixFilePermissions(target, permissions);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy file from %s to %s".formatted(source, target), e);
        }
    }

    public static void writeShellBlock(Path file, String blockId, String blockContent) {
        if (blockContent.endsWith("\n")) {
            blockContent = blockContent.substring(0, blockContent.length() - 1);
        }
        try {
            String originalContent = Files.exists(file, new LinkOption[0]) ? Files.readString(file) : "";
            String updatedContent = TextUtils.addShellBlock(originalContent, blockId, blockContent);
            Files.writeString(file, (CharSequence)updatedContent, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to shell script file: " + String.valueOf(file), e);
        }
    }
}

