package fi.evolver.script.app;

import java.net.URI;

import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.app.Apt.Source;

public class Docker {
	private static final Source APT_SOURCE = Source.builder("docker", URI.create("https://download.docker.com/linux/debian"), "stable")
			.setSignedBy("docker.gpg", URI.create("https://download.docker.com/linux/debian/gpg"))
			.build();

	public static void install() {
		try (Step step = Step.start("Docker: install")) {
			Apt.addSource(APT_SOURCE);
			Apt.purge("docker.io", "docker-doc", "docker-compose", "podman-docker", "containerd", "runc");
			Apt.update();
			Apt.install("docker-ce", "docker-ce-cli", "containerd.io", "docker-buildx-plugin", "docker-compose-plugin");
		}
	}

	public static void addCurrentUserToDockerGroup() {
		addUserToDockerGroup(Shell.USER);
	}

	public static void addUserToDockerGroup(String user) {
		try (Step step = Step.start("Docker: add %s to docker group".formatted(user))) {
			Shell.sudo("usermod", "-aG", "docker", user);
		}
	}
}
