package fi.evolver.script;

import static org.junit.jupiter.api.Assertions.assertEquals;

import org.junit.jupiter.api.Test;


public class EnvironmentTest {
    
	@Test
	public void escapeValue() {
		assertEquals("''\\'''", Environment.escapeValue("'"));
		assertEquals("'\"'", Environment.escapeValue("\""));
		assertEquals("' '", Environment.escapeValue(" "));
		assertEquals("''", Environment.escapeValue(""));
	}

	@Test
	public void unescapeValue() {
		assertEquals("'", Environment.unescapeValue("''\\'''"));
		assertEquals("\"", Environment.unescapeValue("\"\"\""));
		assertEquals("\"", Environment.unescapeValue("\\\""));
		assertEquals("$", Environment.unescapeValue("$"));
		assertEquals(" ", Environment.unescapeValue(" "));
		assertEquals("", Environment.unescapeValue(""));
	}

}
