package io.bitsensor.plugins.java.sql.handler;

import io.bitsensor.lib.entity.proto.Invocation.SQLInvocation;
import io.bitsensor.plugins.java.core.BitSensor;
import org.springframework.stereotype.Component;

import java.sql.Statement;

import static io.bitsensor.plugins.java.core.handler.Handler.ExecutionMoment.PRE_HANDLE;

@Component
public class ExecuteHandler implements SQLHandler {
    @Override
    public void handle(Statement statement, SQLInvocation.Builder builder) {
        BitSensor.addSQLInvocation(builder.build());
    }

    @Override
    public ExecutionMoment getExecutionMoment() {
        return PRE_HANDLE;
    }
}
