/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import io.codemodder.CodeChanger;
import io.codemodder.CodeDirectoryModule;
import io.codemodder.Codemod;
import io.codemodder.CodemodIdPair;
import io.codemodder.CodemodProvider;
import io.codemodder.CodemodRegulator;
import io.codemodder.DefaultRuleSetting;
import io.codemodder.ParameterArgument;
import io.codemodder.ParameterModule;
import io.codemodder.ReviewGuidance;
import io.codemodder.RuleSarif;
import io.codemodder.WantsSarif;
import io.codemodder.XPathStreamProcessorModule;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.jetbrains.annotations.VisibleForTesting;

public final class CodemodLoader {
    private final List<CodemodIdPair> codemods;
    private static final Pattern codemodIdPattern = Pattern.compile("^([A-Za-z0-9]+):(([A-Za-z0-9]+)\\/)+([A-Za-z0-9\\-]+)$");

    public CodemodLoader(List<Class<? extends CodeChanger>> codemodTypes, Path repositoryDir) {
        this(codemodTypes, CodemodRegulator.of(DefaultRuleSetting.ENABLED, List.of()), repositoryDir, Map.of(), List.of());
    }

    public CodemodLoader(List<Class<? extends CodeChanger>> codemodTypes, Path repositoryDir, List<ParameterArgument> parameterArguments) {
        this(codemodTypes, CodemodRegulator.of(DefaultRuleSetting.ENABLED, List.of()), repositoryDir, Map.of(), parameterArguments);
    }

    public CodemodLoader(List<Class<? extends CodeChanger>> codemodTypes, Path repositoryDir, Map<String, List<RuleSarif>> ruleSarifByTool) {
        this(codemodTypes, CodemodRegulator.of(DefaultRuleSetting.ENABLED, List.of()), repositoryDir, ruleSarifByTool, List.of());
    }

    public CodemodLoader(List<Class<? extends CodeChanger>> codemodTypes, CodemodRegulator codemodRegulator, Path repositoryDir, Map<String, List<RuleSarif>> ruleSarifByTool, List<ParameterArgument> codemodParameters) {
        List<CodemodProvider> providers = ServiceLoader.load(CodemodProvider.class).stream().map(ServiceLoader.Provider::get).toList();
        HashSet<AbstractModule> allModules = new HashSet<AbstractModule>();
        HashSet<String> packagesScanned = new HashSet<String>();
        ArrayList<Parameter> injectableParameters = new ArrayList<Parameter>();
        for (Class<? extends CodeChanger> codemodType : codemodTypes) {
            String packageName = codemodType.getPackageName();
            if (packagesScanned.contains(packageName)) continue;
            packagesScanned.add(packageName);
            ScanResult scan = new ClassGraph().enableAllInfo().acceptPackagesNonRecursive(new String[]{packageName}).removeTemporaryFilesAfterScan().scan();
            try {
                ClassInfoList classesWithMethodAnnotation = scan.getClassesWithMethodAnnotation(Inject.class);
                List injectableClasses = classesWithMethodAnnotation.loadClasses();
                List<Parameter> targetedParams = injectableClasses.stream().map(Class::getDeclaredConstructors).flatMap(Arrays::stream).filter(constructor -> constructor.isAnnotationPresent(Inject.class)).map(Executable::getParameters).flatMap(Arrays::stream).filter(param -> param.getAnnotations().length > 0).toList();
                injectableParameters.addAll(targetedParams);
            }
            finally {
                if (scan == null) continue;
                scan.close();
            }
        }
        allModules.add(new CodeDirectoryModule(repositoryDir));
        allModules.add(new XPathStreamProcessorModule());
        allModules.add(new ParameterModule(codemodParameters, injectableParameters));
        for (CodemodProvider provider : providers) {
            List<String> wantsSarif = CodemodLoader.getWantsSarif(provider);
            List<RuleSarif> allWantedSarifs = wantsSarif.stream().flatMap(toolName -> ruleSarifByTool.getOrDefault(toolName, List.of()).stream()).toList();
            Set<AbstractModule> modules = provider.getModules(repositoryDir, codemodTypes, allWantedSarifs);
            allModules.addAll(modules);
        }
        ArrayList<CodemodIdPair> codemods = new ArrayList<CodemodIdPair>();
        Injector injector = Guice.createInjector(allModules);
        HashSet<String> codemodIds = new HashSet<String>();
        for (Class<? extends CodeChanger> type : codemodTypes) {
            Codemod codemodAnnotation = type.getAnnotation(Codemod.class);
            CodemodLoader.validateRequiredFields(codemodAnnotation);
            CodeChanger codeChanger = (CodeChanger)injector.getInstance(type);
            String codemodId = codemodAnnotation.id();
            if (codemodIds.contains(codemodId)) {
                throw new UnsupportedOperationException("multiple codemods under id: " + codemodId);
            }
            codemodIds.add(codemodId);
            if (!codemodRegulator.isAllowed(codemodId)) continue;
            codemods.add(new CodemodIdPair(codemodId, codeChanger));
        }
        this.codemods = Collections.unmodifiableList(codemods);
    }

    public List<CodemodIdPair> getCodemods() {
        return this.codemods;
    }

    private static List<String> getWantsSarif(CodemodProvider provider) {
        return Optional.ofNullable(provider.getClass().getAnnotation(WantsSarif.class)).map(wants -> Arrays.asList(wants.toolNames())).orElse(List.of());
    }

    private static void validateRequiredFields(Codemod codemodAnnotation) {
        String id = codemodAnnotation.id();
        if (!CodemodLoader.isValidCodemodId(id)) {
            throw new IllegalArgumentException("must have valid codemod id");
        }
        ReviewGuidance reviewGuidance = codemodAnnotation.reviewGuidance();
        if (reviewGuidance == null) {
            throw new IllegalArgumentException("must have review guidance");
        }
    }

    @VisibleForTesting
    static boolean isValidCodemodId(String codemodId) {
        return codemodIdPattern.matcher(codemodId).matches();
    }
}

