/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import java.util.Objects;

public interface DependencyGAV {
    public static final DependencyGAV JAVA_SECURITY_TOOLKIT = DependencyGAV.createDefault("io.github.pixee", "java-security-toolkit", "1.0.6");
    public static final DependencyGAV OWASP_XSS_JAVA_ENCODER = DependencyGAV.createDefault("org.owasp.encoder", "encoder", "1.2.3");

    public String group();

    public String artifact();

    public String version();

    public static DependencyGAV createDefault(String group, String artifact, String version) {
        return new Default(group, artifact, version);
    }

    public static class Default
    implements DependencyGAV {
        private final String group;
        private final String artifact;
        private final String version;

        private Default(String group, String artifact, String version) {
            this.group = Objects.requireNonNull(group, "group");
            this.artifact = Objects.requireNonNull(artifact, "artifact");
            this.version = Objects.requireNonNull(version, "version");
        }

        @Override
        public String group() {
            return this.group;
        }

        @Override
        public String artifact() {
            return this.artifact;
        }

        @Override
        public String version() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Default aDefault = (Default)o;
            return this.group.equals(aDefault.group) && this.artifact.equals(aDefault.artifact) && this.version.equals(aDefault.version);
        }

        public int hashCode() {
            return Objects.hash(this.group, this.artifact, this.version);
        }

        public String toString() {
            return "DependencyGAV{group='" + this.group + "', artifact='" + this.artifact + "', version='" + this.version + "'}";
        }
    }
}

