/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.PatternExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.LocalClassDeclarationStmt;
import com.github.javaparser.ast.stmt.LocalRecordDeclarationStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.type.TypeParameter;
import io.codemodder.ast.LocalDeclaration;
import io.codemodder.ast.LocalScope;
import io.codemodder.ast.LocalVariableDeclaration;
import io.codemodder.ast.NameResolver;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javatuples.Pair;
import org.javatuples.Triplet;

public final class ASTs {
    public static Optional<AssignExpr> isAssigned(Expression expr) {
        return expr.getParentNode().map(p -> p instanceof AssignExpr ? (AssignExpr)p : null).filter(ae -> ae.getValue() == expr);
    }

    public static Optional<VariableDeclarator> isInitExpr(Expression expr) {
        return expr.getParentNode().map(p -> p instanceof VariableDeclarator ? (VariableDeclarator)p : null);
    }

    public static Optional<TryStmt> isResource(VariableDeclarationExpr vde) {
        return vde.getParentNode().map(p -> p instanceof TryStmt ? (TryStmt)p : null).filter(ts -> ts.getResources().stream().anyMatch(rs -> rs == vde));
    }

    public static Optional<Statement> isInBlock(Statement stmt) {
        return stmt.getParentNode().map(p -> p instanceof BlockStmt ? (BlockStmt)p : null);
    }

    public static Optional<Pair<TryStmt, VariableDeclarationExpr>> isResource(VariableDeclarator vd) {
        return vd.getParentNode().map(n -> n instanceof VariableDeclarationExpr ? (VariableDeclarationExpr)n : null).flatMap(vde -> ASTs.isResource(vde).map(stmt -> new Pair(stmt, vde)));
    }

    public static Optional<Pair<ForStmt, VariableDeclarationExpr>> isForInitVariable(VariableDeclarator vd) {
        return vd.getParentNode().map(n -> n instanceof VariableDeclarationExpr ? (VariableDeclarationExpr)n : null).flatMap(vde -> vde.getParentNode().map(p -> p instanceof ForStmt ? (ForStmt)p : null).map(fs -> new Pair(fs, vde)));
    }

    public static Optional<Pair<ForEachStmt, VariableDeclarationExpr>> isForEachVariable(VariableDeclarator vd) {
        return vd.getParentNode().map(n -> n instanceof VariableDeclarationExpr ? (VariableDeclarationExpr)n : null).flatMap(vde -> vde.getParentNode().map(p -> p instanceof ForEachStmt ? (ForEachStmt)p : null).map(fs -> new Pair(fs, vde)));
    }

    public static Optional<MethodCallExpr> isScopeInMethodCall(Expression expr) {
        Optional maybe = expr.getParentNode();
        return maybe.map(p -> p instanceof MethodCallExpr ? (MethodCallExpr)p : null).filter(p -> p.getScope().isPresent() && p.getScope().get() == expr);
    }

    public static Optional<Pair<VariableDeclarationExpr, VariableDeclarator>> isVariableDeclarationExprOf(Expression node, String name) {
        if (node instanceof VariableDeclarationExpr) {
            VariableDeclarationExpr vde = node.asVariableDeclarationExpr();
            return vde.getVariables().stream().filter(vd -> vd.getName().asString().equals(name)).findFirst().map(vd -> new Pair((Object)vde, vd));
        }
        return Optional.empty();
    }

    public static Optional<Triplet<ExpressionStmt, VariableDeclarationExpr, VariableDeclarator>> isExpressionStmtDeclarationOf(Node node, String name) {
        ExpressionStmt exprStmt;
        Optional<Pair<VariableDeclarationExpr, VariableDeclarator>> maybePair;
        if (node instanceof ExpressionStmt && (maybePair = ASTs.isVariableDeclarationExprOf((exprStmt = (ExpressionStmt)node).getExpression(), name)).isPresent()) {
            return Optional.of(new Triplet((Object)((ExpressionStmt)node), (Object)((VariableDeclarationExpr)maybePair.get().getValue0()), (Object)((VariableDeclarator)maybePair.get().getValue1())));
        }
        return Optional.empty();
    }

    public static Optional<Triplet<ForEachStmt, VariableDeclarationExpr, VariableDeclarator>> isForEachVariableDeclarationOf(Node node, String name) {
        ForEachStmt fstmt;
        VariableDeclarationExpr vde;
        Optional<VariableDeclarator> maybeVD;
        Predicate<VariableDeclarator> isVDOf = vd -> vd.getName().asString().equals(name);
        if (node instanceof ForEachStmt && (maybeVD = (vde = (fstmt = (ForEachStmt)node).getVariable()).getVariables().stream().filter(isVDOf).findFirst()).isPresent()) {
            return Optional.of(new Triplet((Object)fstmt, (Object)vde, (Object)maybeVD.get()));
        }
        return Optional.empty();
    }

    public static Optional<PatternExpr> isPatternExprDeclarationOf(Node node, String name) {
        PatternExpr pexpr;
        if (node instanceof PatternExpr && (pexpr = (PatternExpr)node).getNameAsString().equals(name)) {
            return Optional.of(pexpr);
        }
        return Optional.empty();
    }

    public static Optional<Pair<LambdaExpr, Parameter>> isLambdaExprParameterOf(Node node, String name) {
        if (node instanceof LambdaExpr) {
            LambdaExpr lexpr = (LambdaExpr)node;
            for (Parameter parameter : lexpr.getParameters()) {
                if (!parameter.getNameAsString().equals(name)) continue;
                return Optional.of(new Pair((Object)lexpr, (Object)parameter));
            }
        }
        return Optional.empty();
    }

    public static Optional<Pair<CatchClause, Parameter>> isExceptionParameterOf(Node node, String name) {
        CatchClause catchClause;
        if (node instanceof CatchClause && (catchClause = (CatchClause)node).getParameter().getNameAsString().equals(name)) {
            return Optional.of(new Pair((Object)catchClause, (Object)catchClause.getParameter()));
        }
        return Optional.empty();
    }

    public static Optional<Pair<MethodDeclaration, Parameter>> isMethodFormalParameterOf(Node node, String name) {
        if (node instanceof MethodDeclaration) {
            MethodDeclaration mdecl = (MethodDeclaration)node;
            for (Parameter parameter : mdecl.getParameters()) {
                if (!parameter.getNameAsString().equals(name)) continue;
                return Optional.of(new Pair((Object)mdecl, (Object)parameter));
            }
        }
        return Optional.empty();
    }

    public static Optional<Pair<MethodDeclaration, TypeParameter>> isMethodTypeParameterOf(Node node, String name) {
        if (node instanceof MethodDeclaration) {
            MethodDeclaration mdecl = (MethodDeclaration)node;
            for (TypeParameter parameter : mdecl.getTypeParameters()) {
                if (!parameter.getNameAsString().equals(name)) continue;
                return Optional.of(new Pair((Object)mdecl, (Object)parameter));
            }
        }
        return Optional.empty();
    }

    public static Optional<NodeWithSimpleName<?>> isNamedMemberOf(BodyDeclaration<?> bodyDecl, String name) {
        NodeWithSimpleName nwn;
        if (bodyDecl instanceof NodeWithSimpleName && (nwn = (NodeWithSimpleName)bodyDecl).getNameAsString().equals(name)) {
            return Optional.of(nwn);
        }
        return Optional.empty();
    }

    public static Optional<Pair<FieldDeclaration, VariableDeclarator>> isFieldDeclarationOf(BodyDeclaration<?> bDecl, String name) {
        if (bDecl instanceof FieldDeclaration) {
            FieldDeclaration m = (FieldDeclaration)bDecl;
            return m.asFieldDeclaration().getVariables().stream().filter(vd -> vd.getNameAsString().equals(name)).findFirst().map(vd -> new Pair((Object)m, vd));
        }
        return Optional.empty();
    }

    public static Optional<Pair<ClassOrInterfaceDeclaration, TypeParameter>> isClassTypeParameterOf(ClassOrInterfaceDeclaration classDecl, String name) {
        for (TypeParameter parameter : classDecl.getTypeParameters()) {
            if (!parameter.getNameAsString().equals(name)) continue;
            return Optional.of(new Pair((Object)classDecl, (Object)parameter));
        }
        return Optional.empty();
    }

    public static Optional<Pair<EnumDeclaration, EnumConstantDeclaration>> isEnumConstantOf(EnumDeclaration enumDecl, String name) {
        Optional<EnumConstantDeclaration> maybeECD = enumDecl.getEntries().stream().filter(ecd -> ecd.getNameAsString().equals(name)).findFirst();
        return maybeECD.map(enumConstantDeclaration -> new Pair((Object)enumDecl, enumConstantDeclaration));
    }

    public static Optional<Pair<ConstructorDeclaration, Parameter>> isConstructorFormalParameterOf(Node node, String name) {
        if (node instanceof ConstructorDeclaration) {
            ConstructorDeclaration mdecl = (ConstructorDeclaration)node;
            for (Parameter parameter : mdecl.getParameters()) {
                if (!parameter.getNameAsString().equals(name)) continue;
                return Optional.of(new Pair((Object)mdecl, (Object)parameter));
            }
        }
        return Optional.empty();
    }

    public static Optional<Pair<ConstructorDeclaration, TypeParameter>> isConstructorTypeParameterOf(Node node, String name) {
        if (node instanceof ConstructorDeclaration) {
            ConstructorDeclaration mdecl = (ConstructorDeclaration)node;
            for (TypeParameter parameter : mdecl.getTypeParameters()) {
                if (!parameter.getNameAsString().equals(name)) continue;
                return Optional.of(new Pair((Object)mdecl, (Object)parameter));
            }
        }
        return Optional.empty();
    }

    public static Optional<Pair<LocalClassDeclarationStmt, ClassOrInterfaceDeclaration>> isLocalTypeDeclarationOf(Node node, String name) {
        LocalClassDeclarationStmt stmtDecl;
        if (node instanceof LocalClassDeclarationStmt && (stmtDecl = (LocalClassDeclarationStmt)node).getClassDeclaration().getNameAsString().equals(name)) {
            return Optional.of(new Pair((Object)stmtDecl, (Object)stmtDecl.getClassDeclaration()));
        }
        return Optional.empty();
    }

    public static Optional<Pair<LocalRecordDeclarationStmt, RecordDeclaration>> isLocalRecordDeclarationOf(Node node, String name) {
        LocalRecordDeclarationStmt stmtDecl;
        if (node instanceof LocalRecordDeclarationStmt && (stmtDecl = (LocalRecordDeclarationStmt)node).getRecordDeclaration().getNameAsString().equals(name)) {
            return Optional.of(new Pair((Object)stmtDecl, (Object)stmtDecl.getRecordDeclaration()));
        }
        return Optional.empty();
    }

    public static Optional<Triplet<ClassOrInterfaceDeclaration, FieldDeclaration, VariableDeclarator>> isClassFieldDeclarationOf(Node node, String name) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration classDecl = (ClassOrInterfaceDeclaration)node;
            for (FieldDeclaration field : classDecl.getFields()) {
                for (VariableDeclarator vd : field.getVariables()) {
                    if (!vd.getNameAsString().equals(name)) continue;
                    return Optional.of(new Triplet((Object)classDecl, (Object)field, (Object)vd));
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<Triplet<ForStmt, VariableDeclarationExpr, VariableDeclarator>> isForVariableDeclarationOf(Node node, String name) {
        Predicate<VariableDeclarator> isVDOf = vd -> vd.getName().asString().equals(name);
        if (node instanceof ForStmt) {
            ForStmt fstmt = (ForStmt)node;
            for (Expression e : fstmt.getInitialization()) {
                Optional<VariableDeclarator> maybeVD;
                if (!(e instanceof VariableDeclarationExpr) || !(maybeVD = e.asVariableDeclarationExpr().getVariables().stream().filter(isVDOf).findFirst()).isPresent()) continue;
                return Optional.of(new Triplet((Object)fstmt, (Object)e.asVariableDeclarationExpr(), (Object)maybeVD.get()));
            }
        }
        return Optional.empty();
    }

    public static Optional<Triplet<TryStmt, VariableDeclarationExpr, VariableDeclarator>> isResourceOf(Node node, String name) {
        if (node instanceof TryStmt) {
            NodeList resources = ((TryStmt)node).getResources();
            for (Expression e : resources) {
                Optional<Pair<VariableDeclarationExpr, VariableDeclarator>> maybePair = ASTs.isVariableDeclarationExprOf(e, name);
                if (!maybePair.isPresent()) continue;
                return Optional.of(new Triplet((Object)((TryStmt)node), (Object)((VariableDeclarationExpr)maybePair.get().getValue0()), (Object)((VariableDeclarator)maybePair.get().getValue1())));
            }
        }
        return Optional.empty();
    }

    public static Optional<ReturnStmt> isReturnExpr(Expression expr) {
        return expr.getParentNode().map(p -> p instanceof ReturnStmt ? (ReturnStmt)p : null);
    }

    public static Optional<MethodCallExpr> isArgumentOfMethodCall(Expression expr) {
        return expr.getParentNode().map(p -> p instanceof MethodCallExpr ? (MethodCallExpr)p : null).filter(mce -> mce.getArguments().stream().anyMatch(arg -> arg == expr));
    }

    public static Optional<ObjectCreationExpr> isArgumentOfObjectCreationExpression(Expression expr) {
        return expr.getParentNode().map(p -> p instanceof ObjectCreationExpr ? (ObjectCreationExpr)p : null).filter(oce -> oce.getArguments().stream().anyMatch(arg -> arg == expr));
    }

    public static boolean isLocalVariableDeclarator(VariableDeclarator vd) {
        Optional maybeParent = vd.getParentNode();
        return maybeParent.filter(p -> !(p instanceof FieldDeclaration)).isPresent();
    }

    public static Optional<ObjectCreationExpr> isConstructorArgument(Expression expr) {
        return expr.getParentNode().map(p -> p instanceof ObjectCreationExpr ? (ObjectCreationExpr)p : null).filter(oce -> oce.getArguments().stream().anyMatch(e -> e == expr));
    }

    public static Optional<Triplet<ExpressionStmt, VariableDeclarationExpr, VariableDeclarator>> isVariableOfLocalDeclarationStmt(VariableDeclarator vd) {
        return vd.getParentNode().map(p -> p instanceof VariableDeclarationExpr ? (VariableDeclarationExpr)p : null).map(vde -> vde.getParentNode().isPresent() && vde.getParentNode().get() instanceof ExpressionStmt ? new Triplet((Object)((ExpressionStmt)vde.getParentNode().get()), vde, (Object)vd) : null);
    }

    public static Optional<FieldDeclaration> isVariableOfField(VariableDeclarator vd) {
        return vd.getParentNode().map(n -> n instanceof FieldDeclaration ? (FieldDeclaration)n : null);
    }

    public static Optional<MethodDeclaration> findMethodBodyFrom(Node node) {
        while (node.getParentNode().isPresent() && !(node.getParentNode().get() instanceof MethodDeclaration)) {
            node = (Node)node.getParentNode().get();
        }
        Optional methodDeclarationOrNullRef = node.getParentNode();
        return methodDeclarationOrNullRef.map(value -> (MethodDeclaration)value);
    }

    public static Optional<BlockStmt> findBlockStatementFrom(Node node) {
        while (node.getParentNode().isPresent() && !(node.getParentNode().get() instanceof BlockStmt)) {
            node = (Node)node.getParentNode().get();
        }
        if (node.getParentNode().isPresent() && node.getParentNode().get() instanceof BlockStmt) {
            return Optional.of((BlockStmt)node.getParentNode().get());
        }
        return Optional.empty();
    }

    public static Optional<Statement> findParentStatementFrom(Node node) {
        while (node.getParentNode().isPresent() && !(node.getParentNode().get() instanceof Statement)) {
            node = (Node)node.getParentNode().get();
        }
        if (node.getParentNode().isPresent() && node.getParentNode().get() instanceof Statement) {
            return Optional.of((Statement)node.getParentNode().get());
        }
        return Optional.empty();
    }

    public static ClassOrInterfaceDeclaration findTypeFrom(Node node) {
        while (node.getParentNode().isPresent() && !(node.getParentNode().get() instanceof ClassOrInterfaceDeclaration)) {
            node = (Node)node.getParentNode().get();
        }
        Optional type = node.getParentNode();
        return type.orElse(null);
    }

    public static boolean isFinalOrNeverAssigned(LocalVariableDeclaration lvd) {
        return ASTs.isFinalOrNeverAssigned(lvd.getVariableDeclarator(), lvd.getScope());
    }

    public static boolean isFinalOrNeverAssigned(VariableDeclarator vd, LocalScope scope) {
        VariableDeclarationExpr vde = (VariableDeclarationExpr)vd.getParentNode().get();
        if (vde.isFinal()) {
            return true;
        }
        Predicate<UnaryExpr> isOperand = ue -> ue.getExpression().isNameExpr() && ue.getExpression().asNameExpr().getName().asString().equals(vd.getName().asString());
        for (Expression expr : scope.getExpressions()) {
            if (!expr.findFirst(UnaryExpr.class, isOperand).isPresent()) continue;
            return false;
        }
        for (Statement stmt : scope.getStatements()) {
            if (!stmt.findFirst(UnaryExpr.class, isOperand).isPresent()) continue;
            return false;
        }
        Predicate<AssignExpr> isLHS = ae -> ae.getTarget().isNameExpr() && ae.getTarget().asNameExpr().getNameAsString().equals(vd.getNameAsString());
        if (vd.getInitializer().isPresent()) {
            for (Statement stmt : scope.getStatements()) {
                if (!stmt.findFirst(AssignExpr.class, isLHS).isPresent()) continue;
                return false;
            }
            for (Expression expr : scope.getExpressions()) {
                if (!expr.findFirst(AssignExpr.class, isLHS).isPresent()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static ClassOrInterfaceDeclaration findThisDeclaration(ThisExpr thisExpr) {
        return NameResolver.findThisDeclaration(thisExpr);
    }

    public static boolean isNotInitializedAndAssignedAtMostOnce(LocalVariableDeclaration lvd) {
        Predicate<AssignExpr> isLHS = ae -> ae.getTarget().isNameExpr() && ae.getTarget().asNameExpr().getName().asString().equals(lvd.getVariableDeclarator().getName().asString());
        if (lvd.getVariableDeclarator().getInitializer().isEmpty()) {
            Stream allAssignments = Stream.concat(lvd.getScope().getExpressions().stream().flatMap(e -> e.findAll(AssignExpr.class, isLHS).stream()), lvd.getScope().getStatements().stream().flatMap(s -> s.findAll(AssignExpr.class, isLHS).stream()));
            return allAssignments.count() == 1L;
        }
        return false;
    }

    public static List<NameExpr> findAllReferences(LocalVariableDeclaration localDeclaration) {
        return localDeclaration.getScope().stream().flatMap(n -> n.findAll(NameExpr.class, ne -> ne.getNameAsString().equals(localDeclaration.getName())).stream()).filter(ne -> ASTs.findNonCallableSimpleNameSource(ne.getName()).filter(n -> n == localDeclaration.getVariableDeclarator()).isPresent()).collect(Collectors.toList());
    }

    public static ReverseEvaluationOrder reversePreOrderIterator(Node n) {
        if (n.getParentNode().isPresent()) {
            int pos = ((Node)n.getParentNode().get()).getChildNodes().indexOf(n);
            return new ReverseEvaluationOrder(n, pos);
        }
        return new ReverseEvaluationOrder(n, 0);
    }

    public static Optional<Node> findNonCallableSimpleNameSource(SimpleName name) {
        return ASTs.findNonCallableSimpleNameSource((Node)name, name.asString());
    }

    public static Optional<Node> findNonCallableSimpleNameSource(Node start, String name) {
        return NameResolver.resolveSimpleName(start, name);
    }

    public static Optional<LocalVariableDeclaration> findEarliestLocalVariableDeclarationOf(Node start, String name) {
        return NameResolver.findLocalVariableDeclarationOf(start, name);
    }

    public static Optional<LocalDeclaration> findEarliestLocalDeclarationOf(SimpleName name) {
        return NameResolver.findLocalDeclarationOf((Node)name, name.asString());
    }

    public static Optional<LocalDeclaration> findEarliestLocalDeclarationOf(Node start, String name) {
        return NameResolver.findLocalDeclarationOf(start, name);
    }

    public static final class ReverseEvaluationOrder
    implements Iterator<Node> {
        private Node current;
        private int posFromParent;

        ReverseEvaluationOrder(Node n, int posFromParent) {
            this.current = n;
            this.posFromParent = posFromParent;
        }

        @Override
        public Node next() {
            Node parent = (Node)this.current.getParentNode().get();
            if (this.posFromParent == 0) {
                this.current = (Node)this.current.getParentNode().get();
                this.posFromParent = this.current.getParentNode().isPresent() ? ((Node)this.current.getParentNode().get()).getChildNodes().indexOf(this.current) : 0;
            } else {
                this.current = (Node)parent.getChildNodes().get(--this.posFromParent);
            }
            return this.current;
        }

        @Override
        public boolean hasNext() {
            return this.current.getParentNode().isPresent();
        }
    }
}

