/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.ast;

import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.TryStmt;
import io.codemodder.ast.ExpressionStmtVariableDeclaration;
import io.codemodder.ast.ForEachDeclaration;
import io.codemodder.ast.ForInitDeclaration;
import io.codemodder.ast.LocalDeclaration;
import io.codemodder.ast.LocalScope;
import io.codemodder.ast.TryResourceDeclaration;
import java.util.Optional;

public abstract class LocalVariableDeclaration
implements LocalDeclaration {
    protected VariableDeclarationExpr vde;
    protected VariableDeclarator vd;
    protected LocalScope scope;

    @Override
    public String getName() {
        return this.vd.getNameAsString();
    }

    public VariableDeclarator getDeclaration() {
        return this.vd;
    }

    @Override
    public LocalScope getScope() {
        if (this.scope == null) {
            this.scope = this.findScope();
        }
        return this.scope;
    }

    public VariableDeclarator getVariableDeclarator() {
        return this.vd;
    }

    public VariableDeclarationExpr getVariableDeclarationExpr() {
        return this.vde;
    }

    public abstract Statement getStatement();

    protected abstract LocalScope findScope();

    public String toString() {
        return this.getStatement().toString();
    }

    public static Optional<LocalVariableDeclaration> fromVariableDeclarator(VariableDeclarator vd) {
        Optional<VariableDeclarationExpr> maybeVDE = vd.getParentNode().map(p -> p instanceof VariableDeclarationExpr ? (VariableDeclarationExpr)p : null);
        if (maybeVDE.isEmpty()) {
            return Optional.empty();
        }
        VariableDeclarationExpr vde = maybeVDE.get();
        Statement stmt = (Statement)vde.getParentNode().get();
        if (stmt instanceof TryStmt) {
            return Optional.of(new TryResourceDeclaration(stmt.asTryStmt(), vde, vd));
        }
        if (stmt instanceof ExpressionStmt) {
            return Optional.of(new ExpressionStmtVariableDeclaration(stmt.asExpressionStmt(), vde, vd));
        }
        if (stmt instanceof ForEachStmt) {
            return Optional.of(new ForEachDeclaration(stmt.asForEachStmt(), vde, vd));
        }
        if (stmt instanceof ForStmt) {
            return Optional.of(new ForInitDeclaration(stmt.asForStmt(), vde, vd));
        }
        return Optional.empty();
    }
}

