/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import io.codemodder.DependencyGAV;
import io.codemodder.Parameter;
import io.codemodder.codetf.CodeTFParameter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class CodemodChange {
    private final int lineNumber;
    private final List<DependencyGAV> dependenciesNeeded;
    private final List<CodeTFParameter> parameters;
    @Nullable
    private final String description;

    private CodemodChange(int lineNumber, List<DependencyGAV> dependenciesNeeded) {
        this.lineNumber = lineNumber;
        this.dependenciesNeeded = Objects.requireNonNull(dependenciesNeeded, "dependenciesNeeded");
        this.parameters = List.of();
        this.description = null;
    }

    private CodemodChange(int lineNumber, String description) {
        this.lineNumber = lineNumber;
        this.dependenciesNeeded = List.of();
        this.parameters = List.of();
        this.description = Objects.requireNonNull(description);
    }

    private CodemodChange(int lineNumber, Parameter parameter, String valueUsed) {
        this.lineNumber = lineNumber;
        this.dependenciesNeeded = List.of();
        CodeTFParameter codeTFParameter = new CodeTFParameter(parameter.getQuestion(), parameter.getName(), parameter.getType(), parameter.getLabel(), valueUsed);
        this.parameters = List.of(codeTFParameter);
        this.description = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodemodChange weave = (CodemodChange)o;
        return this.lineNumber == weave.lineNumber && this.dependenciesNeeded.equals(weave.dependenciesNeeded);
    }

    public int hashCode() {
        return Objects.hash(this.lineNumber, this.dependenciesNeeded);
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public List<CodeTFParameter> getParameters() {
        return this.parameters;
    }

    public List<DependencyGAV> getDependenciesNeeded() {
        return this.dependenciesNeeded;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public static CodemodChange from(int line, List<DependencyGAV> dependenciesNeeded) {
        return new CodemodChange(line, dependenciesNeeded);
    }

    public static CodemodChange from(int line, DependencyGAV dependencyNeeded) {
        return new CodemodChange(line, List.of(dependencyNeeded));
    }

    public static CodemodChange from(int line) {
        return new CodemodChange(line, List.of());
    }

    public static CodemodChange from(int line, Parameter parameter, String valueUsed) {
        return new CodemodChange(line, parameter, valueUsed);
    }

    public static CodemodChange from(int line, String description) {
        return new CodemodChange(line, description);
    }

    public String toString() {
        return "CodemodChange{lineNumber=" + this.lineNumber + ", dependenciesNeeded=" + this.dependenciesNeeded + ", parameters=" + this.parameters + ", description=" + this.description + "}";
    }
}

