/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.codemodder.CodeChanger;
import io.codemodder.CodemodChange;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;

public interface CodemodReporterStrategy {
    public String getSummary();

    public String getDescription();

    public String getChange(Path var1, CodemodChange var2);

    public List<String> getReferences();

    public static CodemodReporterStrategy fromClasspath(Class<? extends CodeChanger> codemodType) {
        String description;
        JsonNode parent;
        Objects.requireNonNull(codemodType);
        String descriptionResource = "/" + codemodType.getName().replace('.', '/') + "/description.md";
        String reportJson = "/" + codemodType.getName().replace('.', '/') + "/report.json";
        ObjectMapper mapper = new ObjectMapper();
        try {
            InputStream jsonResource = codemodType.getResourceAsStream(reportJson);
            InputStream mdResource = codemodType.getResourceAsStream(descriptionResource);
            if (jsonResource == null || mdResource == null) {
                throw new IllegalArgumentException("Could not find report.json or description.md for: " + codemodType);
            }
            parent = mapper.readTree(jsonResource);
            description = IOUtils.toString((InputStream)mdResource);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        final String summary = parent.get("summary").asText();
        final String change = parent.get("change").asText();
        ArrayNode referencesNode = (ArrayNode)parent.get("references");
        final List references = StreamSupport.stream(referencesNode.spliterator(), false).map(JsonNode::asText).collect(Collectors.toList());
        return new CodemodReporterStrategy(){

            @Override
            public String getSummary() {
                return summary;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public String getChange(Path path, CodemodChange codeChange) {
                return change;
            }

            @Override
            public List<String> getReferences() {
                return references;
            }
        };
    }

    public static CodemodReporterStrategy empty() {
        return new CodemodReporterStrategy(){

            @Override
            public String getSummary() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getDescription() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getChange(Path path, CodemodChange change) {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<String> getReferences() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

