/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import io.codemodder.CodeDirectory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

final class DefaultCodeDirectory
implements CodeDirectory {
    private final Path repositoryDir;

    DefaultCodeDirectory(Path repositoryDir) {
        if (!Files.exists(repositoryDir, new LinkOption[0])) {
            throw new IllegalArgumentException("code directory doesn't exist");
        }
        if (!Files.isDirectory(repositoryDir, new LinkOption[0])) {
            throw new IllegalArgumentException("code directory isn't a directory");
        }
        if (!Files.isReadable(repositoryDir)) {
            throw new IllegalArgumentException("code directory isn't readable");
        }
        this.repositoryDir = Objects.requireNonNull(repositoryDir);
    }

    @Override
    public Path asPath() {
        return this.repositoryDir;
    }
}

