/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import io.codemodder.CodeChanger;
import io.codemodder.CodeTFProvider;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodExecutor;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.CodemodIdPair;
import io.codemodder.CodemodPackageUpdateResult;
import io.codemodder.CodemodRunner;
import io.codemodder.DefaultCodeDirectory;
import io.codemodder.DefaultCodemodInvocationContext;
import io.codemodder.DependencyGAV;
import io.codemodder.DependencyUpdateResult;
import io.codemodder.EncodingDetector;
import io.codemodder.FileCache;
import io.codemodder.FixOnlyCodeChanger;
import io.codemodder.IncludesExcludes;
import io.codemodder.LineIncludesExcludes;
import io.codemodder.ProjectProvider;
import io.codemodder.RawFileChanger;
import io.codemodder.RawFileCodemodRunner;
import io.codemodder.codetf.CodeTFChange;
import io.codemodder.codetf.CodeTFChangesetEntry;
import io.codemodder.codetf.CodeTFDiffSide;
import io.codemodder.codetf.CodeTFPackageAction;
import io.codemodder.codetf.CodeTFResult;
import io.codemodder.codetf.DetectionTool;
import io.codemodder.javaparser.JavaParserChanger;
import io.codemodder.javaparser.JavaParserCodemodRunner;
import io.codemodder.javaparser.JavaParserFacade;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultCodemodExecutor
implements CodemodExecutor {
    private final CodemodIdPair codemod;
    private final List<ProjectProvider> projectProviders;
    private final List<CodeTFProvider> codetfProviders;
    private final JavaParserFacade javaParserFacade;
    private final Path projectDir;
    private final IncludesExcludes includesExcludes;
    private final EncodingDetector encodingDetector;
    private final FileCache fileCache;
    private final int maxFileSize;
    private final int maxFiles;
    private final int maxWorkers;
    private static final Logger log = LoggerFactory.getLogger(DefaultCodemodExecutor.class);

    DefaultCodemodExecutor(Path projectDir, IncludesExcludes includesExcludes, CodemodIdPair codemod, List<ProjectProvider> projectProviders, List<CodeTFProvider> codetfProviders, FileCache fileCache, JavaParserFacade javaParserFacade, EncodingDetector encodingDetector, int maxFileSize, int maxFiles, int maxWorkers) {
        this.projectDir = Objects.requireNonNull(projectDir);
        this.includesExcludes = Objects.requireNonNull(includesExcludes);
        this.codemod = Objects.requireNonNull(codemod);
        this.codetfProviders = Objects.requireNonNull(codetfProviders);
        this.projectProviders = Objects.requireNonNull(projectProviders);
        this.javaParserFacade = Objects.requireNonNull(javaParserFacade);
        this.fileCache = Objects.requireNonNull(fileCache);
        this.encodingDetector = Objects.requireNonNull(encodingDetector);
        this.maxFileSize = maxFileSize;
        this.maxFiles = maxFiles;
        this.maxWorkers = maxWorkers;
    }

    @Override
    public CodeTFResult execute(List<Path> filePaths) {
        DetectionTool detectionTool;
        CodemodRunner codemodRunner;
        ConcurrentSkipListSet unscannableFiles = new ConcurrentSkipListSet();
        DefaultCodeDirectory codeDirectory = new DefaultCodeDirectory(this.projectDir);
        CodeChanger codeChanger = this.codemod.getChanger();
        if (codeChanger instanceof JavaParserChanger) {
            codemodRunner = new JavaParserCodemodRunner(this.javaParserFacade, (JavaParserChanger)codeChanger, this.encodingDetector);
        } else if (codeChanger instanceof RawFileChanger) {
            codemodRunner = new RawFileCodemodRunner((RawFileChanger)codeChanger);
        } else {
            throw new UnsupportedOperationException("unsupported codeChanger type: " + codeChanger.getClass().getName());
        }
        List<Path> codemodTargetFiles = filePaths.stream().filter(codemodRunner::supports).sorted().limit(this.maxFiles != -1 ? (long)this.maxFiles : Long.MAX_VALUE).sorted().toList();
        ArrayList changeset = new ArrayList();
        int workers = this.maxWorkers != -1 ? this.maxWorkers : 1;
        ExecutorService executor = Executors.newFixedThreadPool(workers);
        ExecutorCompletionService service = new ExecutorCompletionService(executor);
        for (Path filePath : codemodTargetFiles) {
            executor.submit(() -> {
                block6: {
                    LineIncludesExcludes lineIncludesExcludes = this.includesExcludes.getIncludesExcludesForFile(filePath.toFile());
                    try {
                        long size;
                        if (this.maxFileSize != -1 && (size = Files.size(filePath)) > (long)this.maxFileSize) {
                            unscannableFiles.add(filePath);
                            return;
                        }
                        String beforeFileContents = this.fileCache.get(filePath);
                        List<DependencyGAV> deps = this.projectProviders.stream().flatMap(provider -> provider.getAllDependencies(this.projectDir, filePath).stream()).toList();
                        DefaultCodemodInvocationContext context = new DefaultCodemodInvocationContext(codeDirectory, filePath, beforeFileContents, this.codemod.getId(), lineIncludesExcludes, deps);
                        CodemodFileScanningResult codemodFileScanningResult = codemodRunner.run(context);
                        List<CodemodChange> codemodChanges = codemodFileScanningResult.changes();
                        if (codemodChanges.isEmpty()) break block6;
                        DefaultCodemodExecutor defaultCodemodExecutor = this;
                        synchronized (defaultCodemodExecutor) {
                            FilesUpdateResult updateResult = this.updateFiles(codeChanger, filePath, beforeFileContents, codemodChanges);
                            unscannableFiles.addAll(updateResult.filesFailedToChange());
                            changeset.addAll(updateResult.changeset());
                        }
                    }
                    catch (Exception e) {
                        unscannableFiles.add(filePath);
                        log.error("Problem scanning file", (Throwable)e);
                    }
                }
            });
        }
        executor.shutdown();
        try {
            boolean success = executor.awaitTermination(10L, TimeUnit.MINUTES);
            log.trace("Success running codemod: {}", (Object)success);
            while (!executor.isTerminated()) {
                Future future = service.poll(5L, TimeUnit.SECONDS);
                if (future == null) continue;
                log.trace("Finished: {}", future.get());
            }
        }
        catch (Exception e) {
            log.error("Problem waiting for scanning threads to exit", (Throwable)e);
        }
        String string = this.codemod.getId();
        String string2 = codeChanger.getSummary();
        String string3 = codeChanger.getDescription();
        if (codeChanger instanceof FixOnlyCodeChanger) {
            FixOnlyCodeChanger fixOnlyCodeChanger = (FixOnlyCodeChanger)((Object)codeChanger);
            detectionTool = fixOnlyCodeChanger.getDetectionTool();
        } else {
            detectionTool = null;
        }
        CodeTFResult result = new CodeTFResult(string, string2, string3, detectionTool, unscannableFiles.stream().map(file -> this.getRelativePath(this.projectDir, (Path)file)).collect(Collectors.toSet()), codeChanger.getReferences(), Collections.emptyMap(), changeset);
        for (CodeTFProvider provider : this.codetfProviders) {
            result = provider.onResultCreated(result);
        }
        return result;
    }

    private FilesUpdateResult updateFiles(CodeChanger codeChanger, Path filePath, String beforeFileContents, List<CodemodChange> codemodChanges) throws IOException {
        List<Object> pkgActions;
        List<Path> filesFailedToChange = List.of();
        List<DependencyGAV> dependencies = codemodChanges.stream().map(CodemodChange::getDependenciesNeeded).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        List<Object> dependencyChangesetEntries = Collections.emptyList();
        if (!dependencies.isEmpty()) {
            CodemodPackageUpdateResult packageAddResult = this.addPackages(filePath, dependencies);
            filesFailedToChange = new ArrayList<Path>(packageAddResult.filesFailedToChange());
            pkgActions = packageAddResult.packageActions();
            dependencyChangesetEntries = packageAddResult.manifestChanges();
        } else {
            pkgActions = Collections.emptyList();
        }
        List changes = codemodChanges.stream().map(change -> this.translateCodemodChangetoCodeTFChange(codeChanger, filePath, (CodemodChange)change, (List<CodeTFPackageAction>)pkgActions)).collect(Collectors.toList());
        List<String> beforeFile = beforeFileContents.lines().toList();
        String afterContents = Files.readString(filePath);
        List<String> afterFile = afterContents.lines().toList();
        List patchDiff = UnifiedDiffUtils.generateUnifiedDiff((String)filePath.getFileName().toString(), (String)filePath.getFileName().toString(), beforeFile, (Patch)DiffUtils.diff(beforeFile, afterFile), (int)3);
        String diff = String.join((CharSequence)"\n", patchDiff);
        ArrayList<CodeTFChangesetEntry> changeset = new ArrayList<CodeTFChangesetEntry>();
        changeset.add(new CodeTFChangesetEntry(this.getRelativePath(this.projectDir, filePath), diff, changes));
        changeset.addAll(dependencyChangesetEntries);
        this.fileCache.overrideEntry(filePath, afterContents);
        dependencyChangesetEntries.forEach(entry -> this.fileCache.removeEntry(this.projectDir.resolve(entry.getPath())));
        return new FilesUpdateResult(changeset, filesFailedToChange);
    }

    @NotNull
    private CodeTFChange translateCodemodChangetoCodeTFChange(CodeChanger codeChanger, Path filePath, CodemodChange codemodChange, List<CodeTFPackageAction> pkgActions) {
        Optional<String> customizedChangeDescription = codemodChange.getDescription();
        String changeDescription = customizedChangeDescription.orElse(codeChanger.getIndividualChangeDescription(filePath, codemodChange));
        CodeTFChange change = new CodeTFChange(codemodChange.lineNumber(), Collections.emptyMap(), changeDescription, CodeTFDiffSide.LEFT, pkgActions, codemodChange.getParameters());
        for (CodeTFProvider provider : this.codetfProviders) {
            change = provider.onChangeCreated(filePath, this.codemod.getId(), change);
        }
        return change;
    }

    private CodemodPackageUpdateResult addPackages(Path file, List<DependencyGAV> dependencies) throws IOException {
        ArrayList<CodeTFPackageAction> pkgActions = new ArrayList<CodeTFPackageAction>();
        HashSet<Path> unscannableFiles = new HashSet<Path>();
        ArrayList<DependencyGAV> skippedDependencies = new ArrayList<DependencyGAV>();
        ArrayList<CodeTFChangesetEntry> pkgChanges = new ArrayList<CodeTFChangesetEntry>();
        for (ProjectProvider projectProvider : this.projectProviders) {
            String packageUrl;
            DependencyUpdateResult result = projectProvider.updateDependencies(this.projectDir, file, dependencies);
            unscannableFiles.addAll(result.erroredFiles().stream().map(Path::toAbsolutePath).toList());
            pkgChanges.addAll(result.packageChanges());
            for (DependencyGAV dependency : result.injectedPackages()) {
                packageUrl = DefaultCodemodExecutor.toPackageUrl(dependency);
                pkgActions.add(new CodeTFPackageAction(CodeTFPackageAction.CodeTFPackageActionType.ADD, CodeTFPackageAction.CodeTFPackageActionResult.COMPLETED, packageUrl));
            }
            for (DependencyGAV dependency : result.skippedPackages()) {
                packageUrl = DefaultCodemodExecutor.toPackageUrl(dependency);
                skippedDependencies.add(dependency);
                pkgActions.add(new CodeTFPackageAction(CodeTFPackageAction.CodeTFPackageActionType.ADD, CodeTFPackageAction.CodeTFPackageActionResult.SKIPPED, packageUrl));
            }
            dependencies.removeAll(new HashSet<DependencyGAV>(result.injectedPackages()));
        }
        dependencies.stream().filter(d -> !skippedDependencies.contains(d)).forEach(dep -> pkgActions.add(new CodeTFPackageAction(CodeTFPackageAction.CodeTFPackageActionType.ADD, CodeTFPackageAction.CodeTFPackageActionResult.FAILED, DefaultCodemodExecutor.toPackageUrl(dep))));
        return CodemodPackageUpdateResult.from(pkgActions, pkgChanges, unscannableFiles);
    }

    @VisibleForTesting
    static String toPackageUrl(DependencyGAV dependency) {
        return "pkg:maven/" + dependency.group() + "/" + dependency.artifact() + "@" + dependency.version();
    }

    private String getRelativePath(Path projectDir, Path filePath) {
        String path = projectDir.relativize(filePath).toString();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    private record FilesUpdateResult(List<CodeTFChangesetEntry> changeset, List<Path> filesFailedToChange) {
    }
}

