/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import java.util.Objects;
import java.util.Optional;

public interface DependencyGAV {
    public static final String JAVA_SECURITY_TOOLKIT_VERSION = "1.1.3";
    public static final String JAVA_SECURITY_TOOLKIT_GAV = "io.github.pixee:java-security-toolkit:1.1.3";
    public static final DependencyGAV JAVA_SECURITY_TOOLKIT = DependencyGAV.createDefault("io.github.pixee", "java-security-toolkit", "1.1.3", "This library holds security tools for protecting Java API calls.", "MIT", "https://github.com/pixee/java-security-toolkit", false);
    public static final DependencyGAV OWASP_XSS_JAVA_ENCODER = DependencyGAV.createDefault("org.owasp.encoder", "encoder", "1.2.3", "This library holds XSS encoders for different contexts.", "BSD 3-Clause", "https://github.com/OWASP/owasp-java-encoder", true);

    public String group();

    public String artifact();

    public String version();

    public Optional<String> justification();

    public Optional<String> repositoryUrl();

    public Optional<Boolean> hasNoTransitiveDependencies();

    public Optional<String> license();

    public static DependencyGAV createDefault(String group, String artifact, String version) {
        return new Default(group, artifact, version, null, null, null, null);
    }

    public static DependencyGAV createDefault(String group, String artifact, String version, String justification, String license, String repositoryUrl, Boolean noTransitiveDependencies) {
        return new Default(group, artifact, version, justification, license, repositoryUrl, noTransitiveDependencies);
    }

    public static class Default
    implements DependencyGAV {
        private final String group;
        private final String artifact;
        private final String version;
        private final String license;
        private final String justification;
        private final String repositoryUrl;
        private final Boolean noTransitiveDependencies;

        private Default(String group, String artifact, String version, String justification, String license, String repositoryUrl, Boolean noTransitiveDependencies) {
            this.group = Objects.requireNonNull(group, "group");
            this.artifact = Objects.requireNonNull(artifact, "artifact");
            this.version = Objects.requireNonNull(version, "version");
            this.justification = justification;
            this.license = license;
            this.repositoryUrl = repositoryUrl;
            this.noTransitiveDependencies = noTransitiveDependencies;
        }

        @Override
        public String group() {
            return this.group;
        }

        @Override
        public String artifact() {
            return this.artifact;
        }

        @Override
        public String version() {
            return this.version;
        }

        @Override
        public Optional<String> justification() {
            return Optional.ofNullable(this.justification);
        }

        @Override
        public Optional<Boolean> hasNoTransitiveDependencies() {
            return Optional.ofNullable(this.noTransitiveDependencies);
        }

        @Override
        public Optional<String> repositoryUrl() {
            return Optional.ofNullable(this.repositoryUrl);
        }

        @Override
        public Optional<String> license() {
            return Optional.ofNullable(this.license);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Default aDefault = (Default)o;
            return this.group.equals(aDefault.group) && this.artifact.equals(aDefault.artifact) && this.version.equals(aDefault.version);
        }

        public int hashCode() {
            return Objects.hash(this.group, this.artifact, this.version);
        }

        public String toString() {
            return "DependencyGAV{group='" + this.group + "', artifact='" + this.artifact + "', version='" + this.version + "'}";
        }
    }
}

