/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import com.github.javaparser.ast.CompilationUnit;
import io.codemodder.CodeChanger;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.CodemodInvocationContext;
import io.codemodder.CodemodReporterStrategy;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.javaparser.JavaParserChanger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class CompositeJavaParserChanger
extends JavaParserChanger {
    private final List<JavaParserChanger> changers;

    protected CompositeJavaParserChanger(CodemodReporterStrategy reporterStrategy, JavaParserChanger ... changers) {
        super(reporterStrategy);
        this.changers = Arrays.asList(Objects.requireNonNull(changers));
    }

    protected CompositeJavaParserChanger(JavaParserChanger ... changers) {
        this.changers = Arrays.asList(Objects.requireNonNull(changers));
    }

    @Override
    public CodemodFileScanningResult visit(CodemodInvocationContext context, CompilationUnit cu) {
        ArrayList<CodemodChange> changes = new ArrayList<CodemodChange>();
        ArrayList<UnfixedFinding> unfixedFindings = new ArrayList<UnfixedFinding>();
        this.changers.forEach(changer -> {
            CodemodFileScanningResult result = changer.visit(context, cu);
            changes.addAll(result.changes());
            unfixedFindings.addAll(result.unfixedFindings());
        });
        return CodemodFileScanningResult.from(changes, unfixedFindings);
    }

    @Override
    public boolean shouldRun() {
        return this.changers.stream().anyMatch(CodeChanger::shouldRun);
    }
}

