/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import com.contrastsecurity.sarif.ReportingDescriptor;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.SarifSchema210;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.codemodder.CodeDirectory;
import io.codemodder.RuleSarif;
import io.codemodder.RuleSarifFactory;
import io.codemodder.SarifParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultSarifParser
implements SarifParser {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSarifParser.class);

    DefaultSarifParser() {
    }

    private Optional<SarifSchema210> readSarifFile(Path sarifFile) {
        try {
            return Optional.of((SarifSchema210)new ObjectMapper().readValue(Files.newInputStream(sarifFile, new OpenOption[0]), SarifSchema210.class));
        }
        catch (IOException e) {
            LOG.error("Problem deserializing SARIF file: {}", (Object)sarifFile, (Object)e);
            return Optional.empty();
        }
    }

    private Optional<Map.Entry<String, RuleSarif>> tryToBuild(String toolName, String rule, SarifSchema210 sarif, CodeDirectory codeDirectory, List<RuleSarifFactory> factories) {
        for (RuleSarifFactory factory : factories) {
            Optional<RuleSarif> maybeRuleSarif = factory.build(toolName, rule, sarif, codeDirectory);
            if (!maybeRuleSarif.isPresent()) continue;
            return Optional.of(Map.entry(toolName, maybeRuleSarif.get()));
        }
        LOG.info("Found SARIF from unsupported tool: {}", (Object)toolName);
        return Optional.empty();
    }

    private String extractRuleId(Result result, Run run) {
        if (result.getRuleId() == null) {
            Integer toolIndex = result.getRule().getToolComponent().getIndex();
            Integer ruleIndex = result.getRule().getIndex();
            Optional<String> maybeRule = run.getTool().getExtensions().stream().skip(toolIndex.intValue()).findFirst().flatMap(tool -> tool.getRules().stream().skip(ruleIndex.intValue()).findFirst()).map(ReportingDescriptor::getId);
            if (maybeRule.isPresent()) {
                return maybeRule.get();
            }
            LOG.info("Could not find rule id for result.");
            return null;
        }
        return result.getRuleId();
    }

    private Stream<Map.Entry<String, RuleSarif>> fromSarif(Run run, SarifSchema210 sarif, CodeDirectory codeDirectory) {
        String toolName = run.getTool().getDriver().getName();
        List<RuleSarifFactory> factories = ServiceLoader.load(RuleSarifFactory.class).stream().map(ServiceLoader.Provider::get).toList();
        List runResults = run.getResults();
        Stream<String> allResults = runResults != null ? runResults.stream().map(result -> this.extractRuleId((Result)result, run)).filter(Objects::nonNull).distinct() : Stream.empty();
        return allResults.flatMap(rule -> this.tryToBuild(toolName, (String)rule, sarif, codeDirectory, factories).stream());
    }

    @Override
    public Map<String, List<RuleSarif>> parseIntoMap(List<Path> sarifFiles, CodeDirectory codeDirectory) {
        HashMap<String, List<RuleSarif>> map = new HashMap<String, List<RuleSarif>>();
        sarifFiles.stream().flatMap(f -> this.readSarifFile((Path)f).stream()).flatMap(sarif -> sarif.getRuns().stream().flatMap(run -> this.fromSarif((Run)run, (SarifSchema210)sarif, codeDirectory))).forEach(p -> map.merge((String)p.getKey(), new ArrayList<RuleSarif>(Collections.singletonList((RuleSarif)p.getValue())), (l1, l2) -> {
            l1.add((RuleSarif)l2.get(0));
            return l1;
        }));
        return map;
    }
}

