/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.ast;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithBody;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithStatements;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.resolution.types.ResolvedType;
import io.codemodder.ast.ASTs;
import io.codemodder.ast.ExpressionStmtVariableDeclaration;
import io.codemodder.ast.LocalScope;
import io.codemodder.ast.LocalVariableDeclaration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;

public final class ASTTransforms {
    private ASTTransforms() {
    }

    public static void addImportIfMissing(CompilationUnit cu, String className) {
        ImportDeclaration newImport;
        NodeList imports = cu.getImports();
        if (ASTTransforms.addInOrderIfNeeded(className, (NodeList<ImportDeclaration>)imports, newImport = new ImportDeclaration(className, false, false))) {
            return;
        }
        cu.addImport(className);
    }

    private static boolean addInOrderIfNeeded(String className, NodeList<ImportDeclaration> imports, ImportDeclaration newImport) {
        if (imports.contains((Node)newImport)) {
            return true;
        }
        for (int i = 0; i < imports.size(); ++i) {
            ImportDeclaration existingImport = (ImportDeclaration)imports.get(i);
            if (existingImport.getNameAsString().compareTo(className) <= 0) continue;
            if (i == 0) {
                existingImport.replace((Node)newImport);
                imports.addAfter((Node)existingImport, (Node)newImport);
                return true;
            }
            imports.addBefore((Node)newImport, (Node)existingImport);
            return true;
        }
        return false;
    }

    public static void addImportIfMissing(CompilationUnit cu, Class<?> clazz) {
        ASTTransforms.addImportIfMissing(cu, clazz.getName());
    }

    public static void addStaticImportIfMissing(CompilationUnit cu, String method) {
        ImportDeclaration newMethodImport;
        NodeList imports = cu.getImports();
        if (ASTTransforms.addInOrderIfNeeded(method, (NodeList<ImportDeclaration>)imports, newMethodImport = new ImportDeclaration(method, true, false))) {
            return;
        }
        cu.addImport(method, true, false);
    }

    public static <N extends Node> void addStatementAt(NodeWithStatements<N> node, Statement stmt, int index) {
        ArrayList<Statement> newStatements = new ArrayList<Statement>();
        int i = 0;
        for (Statement s : node.getStatements()) {
            if (i == index) {
                newStatements.add(stmt);
            }
            newStatements.add(s);
            ++i;
        }
        IntStream.range(0, node.getStatements().size() - 1).forEach(j -> node.getStatements().removeLast());
        if (index == 0) {
            ((Statement)node.getStatements().get(0)).replace((Node)stmt);
        }
        newStatements.stream().skip(1L).forEach(arg_0 -> ((NodeList)node.getStatements()).add(arg_0));
    }

    public static void addStatementBeforeStatement(Statement existingStatement, Statement newStatement) {
        Node parent = (Node)existingStatement.getParentNode().get();
        if (parent instanceof NodeWithBody || parent instanceof IfStmt || parent instanceof LabeledStmt || parent instanceof LambdaExpr) {
            BlockStmt newBody = new BlockStmt();
            existingStatement.replace((Node)newBody);
            newBody.addStatement(newStatement);
            newBody.addStatement(existingStatement);
        } else {
            BlockStmt block = (BlockStmt)parent;
            int existingIndex = block.getStatements().indexOf((Object)existingStatement);
            ASTTransforms.addStatementAt(block, newStatement, existingIndex);
        }
    }

    public static void addStatementAfterStatement(Statement existingStatement, Statement newStatement) {
        Node parent = (Node)existingStatement.getParentNode().get();
        if (parent instanceof NodeWithBody || parent instanceof IfStmt || parent instanceof LabeledStmt || parent instanceof LambdaExpr) {
            BlockStmt newBody = new BlockStmt();
            existingStatement.replace((Node)newBody);
            newBody.addStatement(existingStatement);
            newBody.addStatement(newStatement);
        } else {
            BlockStmt block = (BlockStmt)parent;
            block.getStatements().addAfter((Node)newStatement, (Node)existingStatement);
        }
    }

    public static TryStmt wrapIntoResource(ExpressionStmt stmt, VariableDeclarationExpr vdecl, LocalScope scope) {
        TryStmt wrapper = new TryStmt();
        wrapper.getResources().add((Node)vdecl);
        stmt.getComment().ifPresent(comment -> wrapper.setComment(comment));
        BlockStmt block = new BlockStmt();
        scope.getStatements().forEach(s -> {
            s.remove();
            block.addStatement(s);
        });
        wrapper.setTryBlock(block);
        stmt.replace((Node)wrapper);
        return wrapper;
    }

    public static TryStmt splitResources(TryStmt stmt, int index) {
        int i;
        NodeList resources = stmt.getResources();
        NodeList head = new NodeList();
        NodeList tail = new NodeList();
        for (i = 0; i <= index; ++i) {
            head.add((Node)((Expression)resources.get(i)));
        }
        for (i = index + 1; i < resources.size(); ++i) {
            tail.add((Node)((Expression)resources.get(i)));
        }
        stmt.setResources(head);
        TryStmt innerTry = new TryStmt();
        innerTry.setResources(tail);
        innerTry.setTryBlock(stmt.getTryBlock());
        stmt.setTryBlock(new BlockStmt(new NodeList((Node[])new Statement[]{innerTry})));
        return stmt;
    }

    public static TryStmt combineResources(TryStmt innerTry) {
        TryStmt outerTry = (TryStmt)innerTry.getParentNode().flatMap(Node::getParentNode).get();
        innerTry.getResources().forEach(arg_0 -> ((NodeList)outerTry.getResources()).add(arg_0));
        outerTry.getTryBlock().getStatements().stream().skip(1L).forEach(arg_0 -> ((BlockStmt)innerTry.getTryBlock()).addStatement(arg_0));
        outerTry.setTryBlock(innerTry.getTryBlock());
        return outerTry;
    }

    public static void removeImportIfUnused(CompilationUnit cu, String className) {
        NodeList imports = cu.getImports();
        Optional<ImportDeclaration> importToRemove = imports.stream().filter(i -> i.getNameAsString().equals(className)).findFirst();
        if (importToRemove.isEmpty()) {
            return;
        }
        String simpleName = className.substring(className.lastIndexOf(46) + 1);
        if (cu.findAll(Node.class).stream().filter(n -> n instanceof NodeWithSimpleName).map(n -> (NodeWithSimpleName)n).anyMatch(n -> n.getNameAsString().equals(simpleName))) {
            return;
        }
        if (cu.findAll(ClassOrInterfaceType.class).stream().anyMatch(n -> n.getNameAsString().equals(simpleName))) {
            return;
        }
        if (cu.findAll(Node.class).stream().filter(n -> n instanceof NodeWithName).map(n -> (NodeWithName)n).anyMatch(n -> n.getNameAsString().equals(simpleName))) {
            return;
        }
        cu.remove((Node)importToRemove.get());
    }

    private static boolean isEmptyString(Expression expr) {
        Expression resolved = ASTs.resolveLocalExpression(expr);
        return resolved.isStringLiteralExpr() && resolved.asStringLiteralExpr().getValue().isEmpty();
    }

    public static Expression removeEmptyStringConcatenation(BinaryExpr binexp) {
        if (!binexp.getOperator().equals((Object)BinaryExpr.Operator.PLUS)) {
            return binexp;
        }
        Expression left = binexp.getLeft();
        Expression right = binexp.getRight();
        if (ASTTransforms.isEmptyString(left)) {
            if (ASTTransforms.isEmptyString(right)) {
                return new StringLiteralExpr("");
            }
            return right;
        }
        if (ASTTransforms.isEmptyString(right)) {
            if (ASTTransforms.isEmptyString(left)) {
                return new StringLiteralExpr("");
            }
            return left;
        }
        return binexp;
    }

    public static void removeEmptyStringConcatenation(Node subtree) {
        subtree.findAll(BinaryExpr.class, Node.TreeTraversal.POSTORDER).forEach(binexp -> binexp.replace((Node)ASTTransforms.removeEmptyStringConcatenation(binexp)));
    }

    public static void removeUnusedLocalVariables(Node subtree) {
        for (VariableDeclarator vd : subtree.findAll(VariableDeclarator.class)) {
            Optional<ExpressionStmt> aexprStmt;
            List<AssignExpr> allAssignments;
            Optional<LocalVariableDeclaration> maybelvd = LocalVariableDeclaration.fromVariableDeclarator(vd).filter(lvd -> lvd instanceof ExpressionStmtVariableDeclaration);
            if (!maybelvd.isPresent()) continue;
            LocalVariableDeclaration lvd2 = maybelvd.get();
            List<NameExpr> allReferences = ASTs.findAllReferences(lvd2);
            if (allReferences.isEmpty()) {
                maybelvd.get().getStatement().remove();
            }
            if (allReferences.size() != 1 || !lvd2.getVariableDeclarator().getInitializer().isEmpty() || (allAssignments = ASTs.findAllAssignments(lvd2).limit(2L).toList()).size() != 1 || !(aexprStmt = Optional.of(allAssignments.get(0)).flatMap(Node::getParentNode).map(p -> p instanceof ExpressionStmt ? (ExpressionStmt)p : null)).isPresent()) continue;
            aexprStmt.get().remove();
            lvd2.getStatement().remove();
        }
    }

    private static Optional<StringLiteralExpr> removeAndReturnRightmostExpression(BinaryExpr binExpr) {
        if (binExpr.getRight().isStringLiteralExpr()) {
            StringLiteralExpr right = binExpr.asBinaryExpr().getRight().asStringLiteralExpr();
            binExpr.replace((Node)binExpr.getLeft());
            return Optional.of(right);
        }
        if (binExpr.isStringLiteralExpr()) {
            return Optional.of(binExpr.asStringLiteralExpr());
        }
        return Optional.empty();
    }

    public static void mergeConcatenatedLiterals(Expression e) {
        Expression resolved;
        if (e instanceof EnclosedExpr) {
            if (ASTTransforms.calculateResolvedType(e).filter(rt -> rt.describe().equals("java.lang.String")).isPresent()) {
                ASTTransforms.mergeConcatenatedLiterals(e.asEnclosedExpr().getInner());
            }
        } else if (e instanceof BinaryExpr && e.asBinaryExpr().getOperator().equals((Object)BinaryExpr.Operator.PLUS)) {
            ASTTransforms.mergeConcatenatedLiterals(e.asBinaryExpr().getLeft());
            ASTTransforms.mergeConcatenatedLiterals(e.asBinaryExpr().getRight());
            Expression left = e.asBinaryExpr().getLeft();
            Expression right = e.asBinaryExpr().getRight();
            if (right.isStringLiteralExpr()) {
                if (left.isStringLiteralExpr()) {
                    e.replace((Node)new StringLiteralExpr(left.asStringLiteralExpr().getValue() + right.asStringLiteralExpr().getValue()));
                }
                if (left.isBinaryExpr()) {
                    Optional<StringLiteralExpr> maybeLiteral = ASTTransforms.removeAndReturnRightmostExpression(left.asBinaryExpr());
                    maybeLiteral.ifPresent(sl -> right.replace((Node)new StringLiteralExpr(sl.getValue() + right.asStringLiteralExpr().getValue())));
                }
            }
        } else if (e instanceof NameExpr && ASTTransforms.calculateResolvedType(e).filter(rt -> rt.describe().equals("java.lang.String")).isPresent() && (resolved = ASTs.resolveLocalExpression(e)) != e) {
            ASTTransforms.mergeConcatenatedLiterals(resolved);
        }
    }

    private static Optional<ResolvedType> calculateResolvedType(Expression e) {
        try {
            return Optional.of(e.calculateResolvedType());
        }
        catch (RuntimeException exception) {
            return Optional.empty();
        }
    }

    public static Optional<TryStmt> mergeStackedTryStmts(TryStmt tryStmt) {
        Optional<TryStmt> maybeTryParent = tryStmt.getParentNode().flatMap(p -> p.getParentNode()).map(p -> p instanceof TryStmt ? (TryStmt)p : null).filter(ts -> ts.getTryBlock().getStatements().size() == 1 && ts.getTryBlock().getStatement(0) == tryStmt);
        if (maybeTryParent.isPresent()) {
            tryStmt.remove();
            TryStmt parent = maybeTryParent.get();
            parent.getResources().addAll(tryStmt.getResources());
            parent.getTryBlock().getStatements().addAll(tryStmt.getTryBlock().getStatements());
            return Optional.of(parent);
        }
        return Optional.empty();
    }
}

