/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.MethodCallExpr;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.remediation.FixCandidate;
import io.codemodder.remediation.FixCandidateSearchResults;
import io.codemodder.remediation.FixCandidateSearcher;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

final class DefaultFixCandidateSearcher<T>
implements FixCandidateSearcher<T> {
    private final List<Predicate<MethodCallExpr>> matchers;
    private final String methodName;

    DefaultFixCandidateSearcher(String methodName, List<Predicate<MethodCallExpr>> matchers) {
        this.methodName = methodName;
        this.matchers = matchers;
    }

    @Override
    public FixCandidateSearchResults<T> search(CompilationUnit cu, String path, DetectorRule rule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getLine, Function<T, Integer> getColumn) {
        final ArrayList<UnfixedFinding> unfixedFindings = new ArrayList<UnfixedFinding>();
        final ArrayList<FixCandidate<T>> fixCandidates = new ArrayList<FixCandidate<T>>();
        List<MethodCallExpr> calls = cu.findAll(MethodCallExpr.class).stream().filter(mce -> mce.getRange().isPresent()).filter(mce -> this.methodName == null || this.methodName.equals(mce.getNameAsString())).filter(mce -> this.matchers.stream().allMatch(m -> m.test(mce))).toList();
        for (T issue : issuesForFile) {
            String findingId = getKey.apply(issue);
            int line = getLine.apply(issue);
            Integer column = getColumn.apply(issue);
            List<MethodCallExpr> callsForIssue = calls.stream().filter(mce -> mce.getRange().isPresent()).filter(mce -> ((Range)mce.getRange().get()).begin.line == line).toList();
            if (callsForIssue.size() > 1 && column != null) {
                callsForIssue = callsForIssue.stream().filter(mce -> ((Range)mce.getRange().get()).contains(new Position(line, column.intValue()))).toList();
            }
            if (callsForIssue.isEmpty()) {
                unfixedFindings.add(new UnfixedFinding(findingId, rule, path, Integer.valueOf(line), "No calls at that location"));
                continue;
            }
            if (callsForIssue.size() > 1) {
                unfixedFindings.add(new UnfixedFinding(findingId, rule, path, Integer.valueOf(line), "Multiple calls found at the given location and that may cause confusion"));
                continue;
            }
            MethodCallExpr call = callsForIssue.get(0);
            fixCandidates.add(new FixCandidate<T>(call, issue));
        }
        return new FixCandidateSearchResults<T>(){

            @Override
            public List<UnfixedFinding> unfixableFindings() {
                return unfixedFindings;
            }

            @Override
            public List<FixCandidate<T>> fixCandidates() {
                return fixCandidates;
            }
        };
    }
}

