/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.reflectioninjection;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.DependencyGAV;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.remediation.FixCandidate;
import io.codemodder.remediation.FixCandidateSearchResults;
import io.codemodder.remediation.FixCandidateSearcher;
import io.codemodder.remediation.reflectioninjection.ReflectionInjectionRemediator;
import io.github.pixee.security.Reflection;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

final class DefaultReflectionInjectionRemediator
implements ReflectionInjectionRemediator {
    DefaultReflectionInjectionRemediator() {
    }

    @Override
    public <T> CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getLine, Function<T, Integer> getColumn) {
        FixCandidateSearcher<T> searcher = new FixCandidateSearcher.Builder().withMatcher(mce -> DefaultReflectionInjectionRemediator.isClassForNameCall(cu, mce)).build();
        FixCandidateSearchResults results = searcher.search(cu, path, detectorRule, issuesForFile, getKey, getLine, getColumn);
        ArrayList<CodemodChange> changes = new ArrayList<CodemodChange>();
        for (FixCandidate fixCandidate : results.fixCandidates()) {
            Object issue = fixCandidate.issue();
            String id = getKey.apply(issue);
            int line = getLine.apply(issue);
            MethodCallExpr methodCallExpr = fixCandidate.methodCall();
            DefaultReflectionInjectionRemediator.replaceMethodCallExpression(cu, methodCallExpr);
            CodemodChange change = CodemodChange.from(line, List.of(DependencyGAV.JAVA_SECURITY_TOOLKIT), new FixedFinding(id, detectorRule));
            changes.add(change);
        }
        return CodemodFileScanningResult.from(changes, results.unfixableFindings());
    }

    private static void replaceMethodCallExpression(CompilationUnit cu, MethodCallExpr methodCallExpr) {
        NameExpr name = new NameExpr(Reflection.class.getSimpleName());
        methodCallExpr.setScope((Expression)name);
        methodCallExpr.setName("loadAndVerify");
        ASTTransforms.addImportIfMissing(cu, Reflection.class);
    }

    private static boolean isClassForNameCall(CompilationUnit cu, MethodCallExpr methodCallExpr) {
        boolean scopeMatches = methodCallExpr.getScope().map(expression -> {
            if (expression.isNameExpr()) {
                NameExpr nameExpr = expression.asNameExpr();
                return nameExpr.getNameAsString().equals("Class") || nameExpr.getNameAsString().equals("java.lang.Class");
            }
            return false;
        }).orElse(cu.getImports().stream().anyMatch(importDeclaration -> importDeclaration.isStatic() && importDeclaration.getNameAsString().equals("java.lang.Class.forName")));
        boolean methodNameMatches = methodCallExpr.getNameAsString().equals("forName");
        return scopeMatches && methodNameMatches;
    }
}

