/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import io.codemodder.SourceDirectory;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public interface SourceDirectoryLister {
    public List<SourceDirectory> listJavaSourceDirectories(List<File> var1) throws IOException;

    public static SourceDirectoryLister createDefault() {
        return new DefaultSourceDirectoryLister();
    }

    private static boolean isNotHiddenDirectory(Path path) {
        return !path.getFileName().startsWith(".");
    }

    public static final class DefaultSourceDirectoryLister
    implements SourceDirectoryLister {
        private static final String testDirToken = "test" + File.separatorChar + "java" + File.separatorChar;

        @Override
        public List<SourceDirectory> listJavaSourceDirectories(List<File> directories) throws IOException {
            ArrayList<SourceDirectory> javaSourceDirectories = new ArrayList<SourceDirectory>();
            String javaSourceDir = "src" + File.separatorChar + "main" + File.separatorChar + "java";
            for (File directory : directories) {
                List<Path> javaSourceDirectoryPaths = this.getSourceDirectoryPathsWithSuffix(directory, javaSourceDir);
                List<SourceDirectory> sourceDirectories = this.convertToSourceDirectories(javaSourceDirectoryPaths);
                javaSourceDirectories.addAll(sourceDirectories);
            }
            Collections.sort(javaSourceDirectories);
            return javaSourceDirectories;
        }

        @NotNull
        private List<SourceDirectory> convertToSourceDirectories(List<Path> sourceDirectoryPaths) throws IOException {
            ArrayList<SourceDirectory> sourceDirectories = new ArrayList<SourceDirectory>();
            for (Path sourceDirectoryPath : sourceDirectoryPaths) {
                List<String> javaFilePaths;
                try (Stream<Path> paths = Files.walk(sourceDirectoryPath, new FileVisitOption[0]);){
                    javaFilePaths = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> path.toAbsolutePath().toString()).filter(path -> path.toLowerCase().endsWith(".java")).filter(path -> !path.toLowerCase().contains(testDirToken)).toList();
                }
                sourceDirectories.add(SourceDirectory.createDefault(sourceDirectoryPath.toAbsolutePath(), javaFilePaths));
            }
            return Collections.unmodifiableList(sourceDirectories);
        }

        @NotNull
        private List<Path> getSourceDirectoryPathsWithSuffix(File directory, String pathSuffixDesired) throws IOException {
            String canonicalPathSuffixDesired = pathSuffixDesired.toLowerCase();
            try (Stream<Path> paths = Files.walk(directory.toPath(), new FileVisitOption[0]);){
                List<Path> list = paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(SourceDirectoryLister::isNotHiddenDirectory).filter(dir -> !dir.getFileName().startsWith(".")).filter(dir -> dir.toAbsolutePath().toString().toLowerCase().endsWith(canonicalPathSuffixDesired)).toList();
                return list;
            }
        }
    }
}

