/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.jndiinjection;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.DependencyGAV;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.remediation.FixCandidate;
import io.codemodder.remediation.FixCandidateSearchResults;
import io.codemodder.remediation.FixCandidateSearcher;
import io.codemodder.remediation.jndiinjection.JNDIFixStrategy;
import io.codemodder.remediation.jndiinjection.JNDIInjectionRemediator;
import io.codemodder.remediation.jndiinjection.ReplaceLimitedLookupStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

final class DefaultJNDIInjectionRemediator
implements JNDIInjectionRemediator {
    private final JNDIFixStrategy fixStrategy;

    DefaultJNDIInjectionRemediator() {
        this(new ReplaceLimitedLookupStrategy());
    }

    DefaultJNDIInjectionRemediator(JNDIFixStrategy fixStrategy) {
        this.fixStrategy = Objects.requireNonNull(fixStrategy);
    }

    @Override
    public <T> CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getLine, Function<T, Integer> getColumn) {
        FixCandidateSearcher<T> searcher = new FixCandidateSearcher.Builder().withMethodName("lookup").withMatcher(mce -> mce.getScope().isPresent()).withMatcher(mce -> mce.getArguments().size() == 1).withMatcher(mce -> mce.getArgument(0).isNameExpr()).build();
        FixCandidateSearchResults results = searcher.search(cu, path, detectorRule, issuesForFile, getKey, getLine, getColumn);
        ArrayList unfixedFindings = new ArrayList();
        ArrayList<CodemodChange> changes = new ArrayList<CodemodChange>();
        for (FixCandidate fixCandidate : results.fixCandidates()) {
            List issues = fixCandidate.issues();
            int line = getLine.apply(issues.get(0));
            MethodCallExpr lookupCall = fixCandidate.methodCall();
            Optional parentMethod = lookupCall.findAncestor(new Class[]{MethodDeclaration.class});
            if (parentMethod.isEmpty()) {
                issues.stream().map(getKey).map(findingId -> new UnfixedFinding(findingId, detectorRule, path, Integer.valueOf(line), "No method found around lookup call")).forEach(unfixedFindings::add);
                continue;
            }
            ClassOrInterfaceDeclaration parentClass = (ClassOrInterfaceDeclaration)((MethodDeclaration)parentMethod.get()).findAncestor(new Class[]{ClassOrInterfaceDeclaration.class}).get();
            if (parentClass.isInterface()) {
                issues.stream().map(getKey).map(findingId -> new UnfixedFinding(findingId, detectorRule, path, Integer.valueOf(line), "Cannot add validation method to interface")).forEach(unfixedFindings::add);
                continue;
            }
            Optional lookupStatement = lookupCall.findAncestor(new Class[]{Statement.class});
            if (lookupStatement.isEmpty()) {
                issues.stream().map(getKey).map(findingId -> new UnfixedFinding(findingId, detectorRule, path, Integer.valueOf(line), "No statement found around lookup call")).forEach(unfixedFindings::add);
                continue;
            }
            NameExpr contextNameVariable = lookupCall.getArgument(0).asNameExpr();
            Optional lookupParentNode = ((Statement)lookupStatement.get()).getParentNode();
            if (lookupParentNode.isEmpty()) {
                issues.stream().map(getKey).map(findingId -> new UnfixedFinding(findingId, detectorRule, path, Integer.valueOf(line), "No parent node found around lookup call")).forEach(unfixedFindings::add);
                continue;
            }
            Object t = lookupParentNode.get();
            if (!(t instanceof BlockStmt)) {
                issues.stream().map(getKey).map(findingId -> new UnfixedFinding(findingId, detectorRule, path, Integer.valueOf(line), "No block statement found around lookup call")).forEach(unfixedFindings::add);
                continue;
            }
            BlockStmt blockStmt = (BlockStmt)t;
            int index = blockStmt.getStatements().indexOf(lookupStatement.get());
            List<DependencyGAV> deps = this.fixStrategy.fix(cu, parentClass, lookupCall, contextNameVariable, blockStmt, index);
            List<FixedFinding> fixedFindings = issues.stream().map(getKey).map(findingId -> new FixedFinding(findingId, detectorRule)).toList();
            changes.add(CodemodChange.from(line, deps, fixedFindings));
        }
        ArrayList<UnfixedFinding> allUnfixedFindings = new ArrayList<UnfixedFinding>(results.unfixableFindings());
        allUnfixedFindings.addAll(unfixedFindings);
        return CodemodFileScanningResult.from(changes, allUnfixedFindings);
    }
}

