/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.sqlinjection;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.expr.MethodCallExpr;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.remediation.sqlinjection.SQLParameterizer;
import java.util.Optional;

public final class SQLParameterizerWithCleanup {
    private SQLParameterizerWithCleanup() {
    }

    public static boolean checkAndFix(MethodCallExpr methodCallExpr) {
        Optional<MethodCallExpr> maybeFixed = new SQLParameterizer(methodCallExpr).checkAndFix();
        if (maybeFixed.isPresent()) {
            Optional maybeMethodDecl = methodCallExpr.findAncestor(new Class[]{CallableDeclaration.class});
            maybeMethodDecl.ifPresent(ASTTransforms::removeEmptyStringConcatenation);
            maybeMethodDecl.ifPresent(md -> ASTTransforms.removeUnusedLocalVariables((Node)md));
            maybeFixed.flatMap(mce -> mce.getArguments().getFirst()).ifPresent(ASTTransforms::mergeConcatenatedLiterals);
            return true;
        }
        return false;
    }
}

