/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.javaparser.JavaParser;
import com.google.common.base.Stopwatch;
import io.codemodder.CodeChanger;
import io.codemodder.CodeTFProvider;
import io.codemodder.Codemod;
import io.codemodder.CodemodIdPair;
import io.codemodder.CodemodLoader;
import io.codemodder.CodemodRegulator;
import io.codemodder.DefaultCodeDirectory;
import io.codemodder.DefaultCodemodExecutor;
import io.codemodder.DefaultEncodingDetector;
import io.codemodder.DefaultRuleSetting;
import io.codemodder.EncodingDetector;
import io.codemodder.FileCache;
import io.codemodder.FileFinder;
import io.codemodder.IncludesExcludes;
import io.codemodder.LoggingConfigurator;
import io.codemodder.Logs;
import io.codemodder.ParameterArgument;
import io.codemodder.ProjectProvider;
import io.codemodder.RuleSarif;
import io.codemodder.SarifParser;
import io.codemodder.SourceDirectory;
import io.codemodder.SourceDirectoryLister;
import io.codemodder.codetf.CodeTFChangesetEntry;
import io.codemodder.codetf.CodeTFReport;
import io.codemodder.codetf.CodeTFReportGenerator;
import io.codemodder.codetf.CodeTFResult;
import io.codemodder.javaparser.JavaParserFacade;
import io.codemodder.javaparser.JavaParserFactory;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Provider;
import net.logstash.logback.encoder.LogstashEncoder;
import net.logstash.logback.fieldnames.LogstashFieldNames;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import picocli.CommandLine;

@CommandLine.Command(name="codemodder", mixinStandardHelpOptions=true, description={"Run a codemodder codemod"})
final class CLI
implements Callable<Integer> {
    private final List<Class<? extends CodeChanger>> codemodTypes;
    private final Clock clock;
    private final FileFinder fileFinder;
    private final EncodingDetector encodingDetector;
    private final JavaParserFactory javaParserFactory;
    private final SourceDirectoryLister sourceDirectoryLister;
    private final CodeTFReportGenerator reportGenerator;
    private final String[] args;
    @CommandLine.Option(names={"--output"}, description={"the output file to produce"})
    private File output;
    @CommandLine.Option(names={"--dry-run"}, description={"do everything except make changes to files"}, defaultValue="false")
    private boolean dryRun;
    @CommandLine.Option(names={"--max-files"}, description={"the number of files each codemod can scan"}, defaultValue="-1")
    private int maxFiles;
    @CommandLine.Option(names={"--max-workers"}, description={"the maximum number of workers (threads) to use for parallel processing"}, defaultValue="-1")
    private int maxWorkers;
    @CommandLine.Option(names={"--max-file-size"}, description={"the maximum file size in bytes that each codemod can scan"}, defaultValue="-1")
    private int maxFileSize;
    @CommandLine.Option(names={"--dont-exit"}, description={"dont exit the process after running the codemods"}, hidden=true, defaultValue="false")
    private boolean dontExit;
    @CommandLine.Option(names={"--verbose"}, description={"print more to stdout"}, defaultValue="false")
    private boolean verbose;
    @CommandLine.Option(names={"--output-format"}, description={"the format for the data output file (\"codetf\" or \"diff\")"}, defaultValue="codetf")
    private OutputFormat outputFormat;
    @CommandLine.Option(names={"--log-format"}, description={"the format of log data(\"human\" or \"json\")"}, defaultValue="human")
    private LogFormat logFormat;
    @CommandLine.Option(names={"--project-name"}, description={"a descriptive name for the project being scanned for reporting"})
    private String projectName;
    @CommandLine.Option(names={"--sonar-issues-json"}, description={"comma-separated set of path(s) to file(s) containing the result of a call to the Sonar Web API Issues endpoint"}, split=",")
    private List<String> sonarIssuesJsonFilePaths;
    @CommandLine.Option(names={"--defectdojo-findings-json"}, description={"a path to a file containing the result of a call to the DefectDojo v2 Findings API endpoint"})
    private Path defectDojoFindingsJsonFilePath;
    @CommandLine.Option(names={"--sonar-hotspots-json"}, description={"comma-separated set of path(s) to file(s) containing the result of a call to the Sonar Web API Hotspots endpoint"}, split=",")
    private List<String> sonarHotspotsJsonFilePaths;
    @CommandLine.Option(names={"--contrast-vulnerabilities-xml"}, description={"a path to a file containing the result of a call to the Contrast Assess XML export API"})
    private Path contrastVulnerabilitiesXmlFilePath;
    @CommandLine.Option(names={"--list"}, description={"print codemod(s) metadata, then exit"}, defaultValue="false")
    private boolean listCodemods;
    @CommandLine.Option(names={"--path-include"}, description={"comma-separated set of UNIX glob patterns to include"}, split=",")
    private List<String> pathIncludes;
    @CommandLine.Option(names={"--path-exclude"}, description={"comma-separated set of UNIX glob patterns to exclude"}, split=",")
    private List<String> pathExcludes;
    @CommandLine.Option(names={"--codemod-include"}, description={"comma-separated set of codemod IDs to include"}, split=",")
    private List<String> codemodIncludes;
    @CommandLine.Option(names={"--parameter"}, description={"a codemod parameter"})
    private List<String> codemodParameters;
    @CommandLine.Option(names={"--codemod-exclude"}, description={"comma-separated set of codemod IDs to exclude"}, split=",")
    private List<String> codemodExcludes;
    @CommandLine.Parameters(arity="0..1", paramLabel="DIRECTORY", description={"the directory to run the codemod on"})
    private File projectDirectory;
    @CommandLine.Option(names={"--sarif"}, description={"comma-separated set of path(s) to SARIF file(s) to feed to the codemods"}, split=",")
    private List<String> sarifs;
    private final DryRunTempDirCreationStrategy dryRunTempDirCreationStrategy;
    private static final int SUCCESS = 0;
    private static final int ERROR_CANT_READ_PROJECT_DIRECTORY = 1;
    private static final int ERROR_CANT_WRITE_OUTPUT_FILE = 2;
    private static final int ERROR_INVALID_ARGUMENT = 3;
    private static final List<String> defaultPathIncludes = List.of("**.java", "**/*.java", "pom.xml", "**/pom.xml", "**.jsp", "**/*.jsp", "web.xml", "**/web.xml", ".github/workflows/*.yml", ".github/workflows/*.yaml");
    private static final List<String> defaultPathExcludes = List.of("**/test/**", "**/testFixtures/**", "**/*Test.java", "**/intTest/**", "**/tests/**", "**/target/**", "**/build/**", "**/.mvn/**", ".mvn/**");
    private static final Logger log = LoggerFactory.getLogger(CLI.class);

    CLI(String[] args, List<Class<? extends CodeChanger>> codemodTypes) {
        this(args, codemodTypes, Clock.systemUTC(), new DefaultFileFinder(), new DefaultEncodingDetector(), JavaParserFactory.newFactory(), SourceDirectoryLister.createDefault(), CodeTFReportGenerator.createDefault(), new DefaultDryRunTempDirCreationStrategy());
    }

    CLI(String[] args, List<Class<? extends CodeChanger>> codemodTypes, Clock clock, FileFinder fileFinder, EncodingDetector encodingDetector, JavaParserFactory javaParserFactory, SourceDirectoryLister sourceDirectoryLister, CodeTFReportGenerator reportGenerator, DryRunTempDirCreationStrategy dryRunTempDirCreationStrategy) {
        Objects.requireNonNull(codemodTypes);
        this.codemodTypes = Collections.unmodifiableList(codemodTypes);
        this.clock = Objects.requireNonNull(clock);
        this.fileFinder = Objects.requireNonNull(fileFinder);
        this.encodingDetector = Objects.requireNonNull(encodingDetector);
        this.javaParserFactory = Objects.requireNonNull(javaParserFactory);
        this.sourceDirectoryLister = Objects.requireNonNull(sourceDirectoryLister);
        this.reportGenerator = Objects.requireNonNull(reportGenerator);
        this.args = Objects.requireNonNull(args);
        this.dryRunTempDirCreationStrategy = Objects.requireNonNull(dryRunTempDirCreationStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws IOException {
        if (this.verbose) {
            this.setupVerboseLogging();
        }
        if (LogFormat.JSON.equals((Object)this.logFormat)) {
            this.setupJsonLogging();
        }
        if (this.listCodemods) {
            for (Class<? extends CodeChanger> codemodType : this.codemodTypes) {
                Codemod annotation = codemodType.getAnnotation(Codemod.class);
                log.info(annotation.id());
            }
            return 0;
        }
        Logs.logEnteringPhase(Logs.ExecutionPhase.STARTING);
        log.info("codemodder: java/{}", (Object)CLI.class.getPackage().getImplementationVersion());
        if (this.projectDirectory == null) {
            log.error("No project directory specified");
            return 1;
        }
        Path outputPath = null;
        if (!(this.output == null || Files.exists((outputPath = this.output.getAbsoluteFile().toPath()).getParent(), new LinkOption[0]) && Files.isWritable(outputPath.getParent()))) {
            log.error("The output file parent directory doesn't exist or isn't writable");
            return 2;
        }
        Path projectPath = this.projectDirectory.toPath();
        if (!Files.isDirectory(projectPath, new LinkOption[0]) || !Files.isReadable(projectPath)) {
            log.error("The project directory is not a readable directory");
            return 1;
        }
        if (this.maxWorkers < -1) {
            log.error("Invalid value for workers");
            return -1;
        }
        Logs.logEnteringPhase(Logs.ExecutionPhase.SETUP);
        if (this.dryRun) {
            Path copiedProjectDirectory = this.dryRunTempDirCreationStrategy.createTempDir();
            Stopwatch watch = Stopwatch.createStarted();
            log.debug("dry run temporary directory: {}", (Object)copiedProjectDirectory);
            FileUtils.copyDirectory((File)this.projectDirectory, (File)copiedProjectDirectory.toFile());
            watch.stop();
            Duration elapsed = watch.elapsed();
            log.debug("dry run copy finished: {}ms", (Object)elapsed.toMillis());
            this.projectDirectory = copiedProjectDirectory.toFile();
            projectPath = copiedProjectDirectory;
        }
        try {
            Integer n;
            List<String> pathExcludes;
            Instant start = this.clock.instant();
            List<String> pathIncludes = this.pathIncludes;
            if (pathIncludes == null) {
                pathIncludes = defaultPathIncludes;
            }
            if ((pathExcludes = this.pathExcludes) == null) {
                pathExcludes = defaultPathExcludes;
            }
            IncludesExcludes includesExcludes = IncludesExcludes.withSettings(this.projectDirectory, pathIncludes, pathExcludes);
            log.debug("including paths: {}", pathIncludes);
            log.debug("excluding paths: {}", pathExcludes);
            List<SourceDirectory> sourceDirectories = this.sourceDirectoryLister.listJavaSourceDirectories(List.of(this.projectDirectory));
            List<Path> filePaths = this.fileFinder.findFiles(projectPath, includesExcludes);
            if (this.codemodIncludes != null && this.codemodExcludes != null) {
                log.error("Codemod includes and excludes cannot both be specified");
                Integer n2 = 3;
                return n2;
            }
            CodemodRegulator regulator = this.codemodIncludes == null && this.codemodExcludes == null ? CodemodRegulator.of(DefaultRuleSetting.ENABLED, List.of()) : (this.codemodIncludes != null ? CodemodRegulator.of(DefaultRuleSetting.DISABLED, this.codemodIncludes) : CodemodRegulator.of(DefaultRuleSetting.ENABLED, this.codemodExcludes));
            DefaultCodeDirectory codeDirectory = new DefaultCodeDirectory(projectPath);
            List<Path> sarifFiles = this.convertToPaths(this.sarifs);
            List<Path> sonarIssuesJsonFiles = this.convertToPaths(this.sonarIssuesJsonFilePaths);
            List<Path> sonarHotspotJsonFiles = this.convertToPaths(this.sonarHotspotsJsonFilePaths);
            Map<String, List<RuleSarif>> pathSarifMap = SarifParser.create().parseIntoMap(sarifFiles, codeDirectory);
            List<ParameterArgument> codemodParameters = this.createFromParameterStrings(this.codemodParameters);
            CodemodLoader loader = new CodemodLoader(this.codemodTypes, regulator, projectPath, pathIncludes, pathExcludes, filePaths, pathSarifMap, codemodParameters, sonarIssuesJsonFiles, sonarHotspotJsonFiles, this.defectDojoFindingsJsonFilePath, this.contrastVulnerabilitiesXmlFilePath);
            List<CodemodIdPair> codemods = loader.getCodemods();
            log.debug("sarif files: {}", (Object)sarifFiles.size());
            List<ProjectProvider> projectProviders = this.loadProjectProviders();
            List<CodeTFProvider> codeTFProviders = this.loadCodeTFProviders();
            ArrayList<CodeTFResult> results = new ArrayList<CodeTFResult>();
            Logs.logEnteringPhase(Logs.ExecutionPhase.SCANNING);
            Provider javaParserProvider = () -> {
                try {
                    return this.javaParserFactory.create(sourceDirectories);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
            JavaParserFacade javaParserFacade = JavaParserFacade.from((Provider<JavaParser>)javaParserProvider);
            int maxFileCacheSize = 10000;
            FileCache fileCache = FileCache.createDefault(maxFileCacheSize);
            for (CodemodIdPair codemod : codemods) {
                DefaultCodemodExecutor codemodExecutor = new DefaultCodemodExecutor(projectPath, includesExcludes, codemod, projectProviders, codeTFProviders, fileCache, javaParserFacade, this.encodingDetector, this.maxFileSize, this.maxFiles, this.maxWorkers);
                log.info("running codemod: {}", (Object)codemod.getId());
                CodeTFResult result = codemodExecutor.execute(filePaths);
                results.add(result);
                if (!result.getChangeset().isEmpty()) {
                    log.info("changed:");
                    result.getChangeset().forEach(entry -> {
                        log.info("  - " + entry.getPath());
                        String indentedDiff = entry.getDiff().lines().map(line -> "      " + line).collect(Collectors.joining(System.lineSeparator()));
                        log.debug("    diff:");
                        log.debug(indentedDiff);
                    });
                }
                if (result.getFailedFiles().isEmpty()) continue;
                log.info("failed:");
                result.getFailedFiles().forEach(f -> log.info("  - {}", f));
            }
            Instant end = this.clock.instant();
            long elapsed = end.toEpochMilli() - start.toEpochMilli();
            Logs.logEnteringPhase(Logs.ExecutionPhase.REPORT);
            CLI.logMetrics(results);
            if (outputPath != null) {
                if (OutputFormat.CODETF.equals((Object)this.outputFormat)) {
                    CodeTFReport report = this.reportGenerator.createReport(this.projectDirectory.toPath(), String.join((CharSequence)" ", this.args), this.sarifs == null ? List.of() : this.sarifs.stream().map(x$0 -> Path.of(x$0, new String[0])).toList(), results, elapsed);
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                    Files.writeString(outputPath, (CharSequence)mapper.writeValueAsString((Object)report), new OpenOption[0]);
                    log.debug("report file: {}", (Object)outputPath);
                } else if (OutputFormat.DIFF.equals((Object)this.outputFormat)) {
                    throw new UnsupportedOperationException("not supported yet");
                }
            }
            log.debug("elapsed: {}ms", (Object)elapsed);
            if (this.dontExit) {
                n = -1;
                return n;
            }
            n = 0;
            return n;
        }
        finally {
            if (this.dryRun) {
                FileUtils.deleteDirectory((File)this.projectDirectory);
                log.debug("cleaned temp directory: {}", (Object)this.projectDirectory);
            }
        }
    }

    private List<Path> convertToPaths(List<String> pathsStr) {
        return pathsStr != null ? pathsStr.stream().map(x$0 -> Path.of(x$0, new String[0])).toList() : List.of();
    }

    private void setupJsonLogging() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger rootLogger = context.getLogger(LoggingConfigurator.OUR_ROOT_LOGGER_NAME);
        rootLogger.detachAndStopAllAppenders();
        ConsoleAppender appender = new ConsoleAppender();
        appender.setContext((Context)context);
        CLI.configureAppender((OutputStreamAppender<ILoggingEvent>)appender, Optional.ofNullable(this.projectName));
        rootLogger.addAppender((Appender)appender);
    }

    @VisibleForTesting
    static void configureAppender(OutputStreamAppender<ILoggingEvent> appender, Optional<String> projectName) {
        LogstashEncoder logstashEncoder = new LogstashEncoder();
        logstashEncoder.setContext(appender.getContext());
        logstashEncoder.setIncludeCallerData(true);
        LogstashFieldNames fieldNames = logstashEncoder.getFieldNames();
        fieldNames.setCallerFile("file");
        fieldNames.setCallerLine("line");
        fieldNames.setTimestamp("timestamp");
        fieldNames.setCaller(null);
        fieldNames.setCallerClass("[ignore]");
        fieldNames.setCallerMethod("[ignore]");
        fieldNames.setVersion("[ignore]");
        fieldNames.setLogger("[ignore]");
        fieldNames.setThread("[ignore]");
        fieldNames.setLevelValue("[ignore]");
        String projectNameKey = "project_name";
        if (projectName.isPresent()) {
            MDC.put((String)projectNameKey, (String)projectName.get());
        } else {
            MDC.remove((String)projectNameKey);
        }
        logstashEncoder.addIncludeMdcKeyName(projectNameKey);
        logstashEncoder.start();
        appender.setEncoder((Encoder)logstashEncoder);
        appender.start();
    }

    private void setupVerboseLogging() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger rootLogger = context.getLogger(LoggingConfigurator.OUR_ROOT_LOGGER_NAME);
        rootLogger.setLevel(Level.DEBUG);
    }

    private static void logMetrics(List<CodeTFResult> results) {
        List failedFiles = results.stream().flatMap(r -> r.getFailedFiles().stream()).toList();
        List<String> changedFiles = results.stream().flatMap(r -> r.getChangeset().stream()).map(CodeTFChangesetEntry::getPath).toList();
        long uniqueChangedFiles = changedFiles.stream().distinct().count();
        long uniqueFailedFiles = failedFiles.stream().distinct().count();
        log.debug("failed files: {} ({} unique)", (Object)failedFiles.size(), (Object)uniqueFailedFiles);
        log.debug("changed files: {} ({} unique)", (Object)changedFiles.size(), (Object)uniqueChangedFiles);
    }

    private List<CodeTFProvider> loadCodeTFProviders() {
        ArrayList<CodeTFProvider> codeTFProviders = new ArrayList<CodeTFProvider>();
        ServiceLoader<CodeTFProvider> loader = ServiceLoader.load(CodeTFProvider.class);
        for (CodeTFProvider provider : loader) {
            codeTFProviders.add(provider);
        }
        return codeTFProviders;
    }

    private List<ProjectProvider> loadProjectProviders() {
        ArrayList<ProjectProvider> projectProviders = new ArrayList<ProjectProvider>();
        ServiceLoader<ProjectProvider> loader = ServiceLoader.load(ProjectProvider.class);
        for (ProjectProvider projectProvider : loader) {
            projectProviders.add(projectProvider);
        }
        return projectProviders;
    }

    private List<ParameterArgument> createFromParameterStrings(List<String> parameterStrings) {
        if (parameterStrings == null || parameterStrings.isEmpty()) {
            return List.of();
        }
        return parameterStrings.stream().map(ParameterArgument::fromNameValuePairs).toList();
    }

    @VisibleForTesting
    static class DefaultFileFinder
    implements FileFinder {
        DefaultFileFinder() {
        }

        @Override
        public List<Path> findFiles(Path projectDir, IncludesExcludes includesExcludes) {
            List<Path> allFiles;
            try (Stream<Path> paths = Files.walk(projectDir, new FileVisitOption[0]);){
                allFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> !Files.isSymbolicLink(p)).filter(p -> includesExcludes.shouldInspect(p.toFile())).sorted().toList();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return allFiles;
        }
    }

    private static class DefaultDryRunTempDirCreationStrategy
    implements DryRunTempDirCreationStrategy {
        private DefaultDryRunTempDirCreationStrategy() {
        }

        @Override
        public Path createTempDir() throws IOException {
            return Files.createTempDirectory("codemodder-project", new FileAttribute[0]);
        }
    }

    @VisibleForTesting
    static interface DryRunTempDirCreationStrategy {
        public Path createTempDir() throws IOException;
    }

    static enum LogFormat {
        HUMAN,
        JSON;

    }

    static enum OutputFormat {
        CODETF,
        DIFF;

    }
}

