/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.javadeserialization;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.DependencyGAV;
import io.codemodder.ast.ASTs;
import io.codemodder.ast.LocalDeclaration;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.FixCandidate;
import io.codemodder.remediation.FixCandidateSearchResults;
import io.codemodder.remediation.FixCandidateSearcher;
import io.codemodder.remediation.javadeserialization.JavaDeserializationRemediator;
import io.github.pixee.security.ObjectInputFilters;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

final class DefaultJavaDeserializationRemediator
implements JavaDeserializationRemediator {
    DefaultJavaDeserializationRemediator() {
    }

    @Override
    public <T> CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getLine, Function<T, Integer> getColumn) {
        FixCandidateSearcher<T> searcher = new FixCandidateSearcher.Builder().withMethodName("readObject").withMatcher(mce -> mce.getScope().isPresent()).withMatcher(mce -> mce.getArguments().isEmpty()).build();
        FixCandidateSearchResults results = searcher.search(cu, path, detectorRule, issuesForFile, getKey, getLine, getColumn);
        ArrayList<CodemodChange> changes = new ArrayList<CodemodChange>();
        ArrayList<UnfixedFinding> unfixedFindings = new ArrayList<UnfixedFinding>();
        for (FixCandidate fixCandidate : results.fixCandidates()) {
            List issues = fixCandidate.issues();
            MethodCallExpr call = fixCandidate.methodCall();
            Expression callScope = (Expression)call.getScope().get();
            if (!callScope.isNameExpr()) {
                issues.stream().map(i -> new UnfixedFinding((String)getKey.apply(i), detectorRule, path, (Integer)getLine.apply(i), "Unexpected shape")).forEach(unfixedFindings::add);
                continue;
            }
            Optional<LocalDeclaration> declaration = ASTs.findEarliestLocalDeclarationOf(callScope.asNameExpr().getName());
            if (declaration.isEmpty()) {
                issues.stream().map(i -> new UnfixedFinding((String)getKey.apply(i), detectorRule, path, (Integer)getLine.apply(i), "No declaration found")).forEach(unfixedFindings::add);
                continue;
            }
            LocalDeclaration localDeclaration = declaration.get();
            Node varDeclarationAndExpr = localDeclaration.getDeclaration();
            if (varDeclarationAndExpr instanceof VariableDeclarator) {
                VariableDeclarator varDec = (VariableDeclarator)varDeclarationAndExpr;
                Optional initializer = varDec.getInitializer();
                if (initializer.isEmpty()) {
                    issues.stream().map(i -> new UnfixedFinding((String)getKey.apply(i), detectorRule, path, (Integer)getLine.apply(i), "No initializer found")).forEach(unfixedFindings::add);
                    continue;
                }
                Expression expression = (Expression)initializer.get();
                if (!(expression instanceof ObjectCreationExpr)) continue;
                ObjectCreationExpr objCreation = (ObjectCreationExpr)expression;
                this.fixObjectInputStreamCreation(objCreation);
                CodemodChange change = CodemodChange.from((int)getLine.apply(issues.get(0)), List.of(DependencyGAV.JAVA_SECURITY_TOOLKIT), issues.stream().map(i -> new FixedFinding((String)getKey.apply(i), detectorRule)).toList());
                changes.add(change);
                continue;
            }
            issues.stream().map(i -> new UnfixedFinding((String)getKey.apply(i), detectorRule, path, (Integer)getLine.apply(i), "Unexpected declaration type")).forEach(unfixedFindings::add);
        }
        unfixedFindings.addAll(results.unfixableFindings());
        return CodemodFileScanningResult.from(changes, unfixedFindings);
    }

    private void fixObjectInputStreamCreation(ObjectCreationExpr objCreation) {
        JavaParserTransformer.replace((Expression)objCreation).withStaticMethod(ObjectInputFilters.class.getName(), "createSafeObjectInputStream").withStaticImport().withSameArguments();
    }
}

