/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xss;

import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.ReturnStmt;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.xss.XSSCodeShapeFixResult;
import io.codemodder.remediation.xss.XSSCodeShapeFixer;
import java.util.List;
import java.util.function.Function;

final class NakedVariableReturnFixer
implements XSSCodeShapeFixer {
    NakedVariableReturnFixer() {
    }

    @Override
    public <T> XSSCodeShapeFixResult fixCodeShape(CompilationUnit cu, String path, DetectorRule detectorRule, List<T> issues, Function<T, String> getKey, Function<T, Integer> getLine, Function<T, Integer> getColumn) {
        int line = getLine.apply(issues.get(0));
        Integer column = getColumn.apply(issues.get(0));
        List<ReturnStmt> matchingStatements = cu.findAll(ReturnStmt.class).stream().filter(rs -> rs.getRange().isPresent()).filter(rs -> ((Range)rs.getRange().get()).begin.line == line).filter(rs -> column == null || ((Range)rs.getRange().get()).begin.column == column).filter(rs -> rs.getExpression().isPresent()).filter(rs -> ((Expression)rs.getExpression().get()).isNameExpr()).toList();
        if (matchingStatements.isEmpty()) {
            return new XSSCodeShapeFixResult(false, false, null, line);
        }
        if (matchingStatements.size() > 1) {
            return new XSSCodeShapeFixResult(true, false, "Multiple calls found at the given location and that may cause confusion", line);
        }
        ReturnStmt nakedReturn = matchingStatements.get(0);
        JavaParserTransformer.wrap((Expression)nakedReturn.getExpression().get()).withStaticMethod("org.owasp.encoder.Encode", "forHtml", false);
        return new XSSCodeShapeFixResult(true, true, null, line);
    }
}

