/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import io.codemodder.DefaultRuleSetting;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface CodemodRegulator {
    public boolean isAllowed(String var1);

    public Optional<List<String>> desiredCodemodIdOrder();

    public static CodemodRegulator of(DefaultRuleSetting defaultCodemodSetting, List<String> codemodExceptions) {
        return new DefaultCodemodRegulator(defaultCodemodSetting, codemodExceptions);
    }

    public static class DefaultCodemodRegulator
    implements CodemodRegulator {
        private final DefaultRuleSetting setting;
        private final List<String> exceptions;
        private final List<String> desiredOrder;

        DefaultCodemodRegulator(DefaultRuleSetting defaultCodemodSetting, List<String> codemodExceptions) {
            this.setting = Objects.requireNonNull(defaultCodemodSetting);
            this.exceptions = Objects.requireNonNull(codemodExceptions);
            this.desiredOrder = DefaultRuleSetting.ENABLED.equals((Object)defaultCodemodSetting) ? null : codemodExceptions;
        }

        @Override
        public boolean isAllowed(String codemodId) {
            if (DefaultRuleSetting.ENABLED.equals((Object)this.setting)) {
                return !this.exceptions.contains(codemodId);
            }
            return this.exceptions.contains(codemodId);
        }

        @Override
        public Optional<List<String>> desiredCodemodIdOrder() {
            return Optional.ofNullable(this.desiredOrder);
        }
    }
}

