/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import io.codemodder.IncludesExcludes;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public interface IncludesExcludesPattern {
    public IncludesExcludes getRootedMatcher(Path var1);

    public static IncludesExcludesPattern getJavaMatcher() {
        return JavaMatcherSingleton.getInstance();
    }

    public static IncludesExcludesPattern getAnyMatcher() {
        return AnySingleton.getInstance();
    }

    public static final class JavaMatcherSingleton {
        private static IncludesExcludesPattern singleton;

        private JavaMatcherSingleton() {
        }

        static IncludesExcludesPattern getInstance() {
            if (singleton == null) {
                singleton = new Default(Set.of("**.[jJ][aA][vV][Aa]"), Collections.emptySet());
            }
            return singleton;
        }
    }

    public static final class AnySingleton {
        private static IncludesExcludesPattern singleton;

        private AnySingleton() {
        }

        static IncludesExcludesPattern getInstance() {
            if (singleton == null) {
                singleton = new Default(Set.of("**"), Collections.emptySet());
            }
            return singleton;
        }
    }

    public static class Default
    implements IncludesExcludesPattern {
        private final Set<String> pathIncludes;
        private final Set<String> pathExcludes;

        public Default(Set<String> pathIncludes, Set<String> pathExcludes) {
            this.pathIncludes = Objects.requireNonNull(pathIncludes);
            this.pathExcludes = Objects.requireNonNull(pathExcludes);
        }

        public String toString() {
            return "Includes: " + this.pathIncludes + "\nExcludes: " + this.pathExcludes;
        }

        @Override
        public IncludesExcludes getRootedMatcher(Path root) {
            return IncludesExcludes.withSettings(root.toFile(), this.pathIncludes.stream().toList(), this.pathExcludes.stream().toList());
        }
    }
}

