/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public final class PathMatcher {
    private final Integer line;
    private final String repositoryRootPath;
    private final java.nio.file.PathMatcher matcher;

    public PathMatcher(FileSystem fs, File repositoryRoot, String pathPattern, Integer line) {
        this.repositoryRootPath = Path.of(repositoryRoot.getAbsolutePath(), new String[0]).normalize().toString();
        Objects.requireNonNull(pathPattern);
        this.matcher = fs.getPathMatcher("glob:" + pathPattern);
        this.line = line;
    }

    public boolean matches(File file) {
        String candidateFilePath = Path.of(file.getAbsolutePath(), new String[0]).normalize().toString();
        Object relativeCandidateFilePath = candidateFilePath.substring(this.repositoryRootPath.length());
        if (!((String)relativeCandidateFilePath).startsWith("/")) {
            relativeCandidateFilePath = "/" + (String)relativeCandidateFilePath;
        }
        return this.matcher.matches(Paths.get((String)relativeCandidateFilePath, new String[0]));
    }

    public Integer line() {
        return this.line;
    }

    public boolean targetsLine() {
        return this.line != null;
    }

    public String toString() {
        return this.matcher.toString() + ":" + this.line;
    }
}

