/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import io.codemodder.CodemodFileScanningResult;
import io.codemodder.CodemodInvocationContext;
import io.codemodder.CodemodRunner;
import io.codemodder.IncludesExcludes;
import io.codemodder.RawFileChanger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;

final class RawFileCodemodRunner
implements CodemodRunner {
    private final RawFileChanger changer;
    private final IncludesExcludes rootedFileMatcher;

    RawFileCodemodRunner(RawFileChanger changer, Path projectDir) {
        this.changer = Objects.requireNonNull(changer);
        this.rootedFileMatcher = changer.getIncludesExcludesPattern().getRootedMatcher(projectDir);
    }

    RawFileCodemodRunner(RawFileChanger changer, IncludesExcludes globalIncludesExcludes) {
        this.changer = Objects.requireNonNull(changer);
        this.rootedFileMatcher = Objects.requireNonNull(globalIncludesExcludes);
    }

    @Override
    public boolean supports(Path path) {
        return this.rootedFileMatcher.shouldInspect(path.toFile()) && this.changer.supports(path);
    }

    @Override
    public CodemodFileScanningResult run(CodemodInvocationContext context) throws IOException {
        return this.changer.visitFile(context);
    }
}

