/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.ast;

import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.resolution.types.ResolvedType;
import io.codemodder.ast.ASTs;
import io.codemodder.ast.LocalVariableDeclaration;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class LinearizedStringExpression {
    private final Map<Expression, Expression> resolvedExpressions = new IdentityHashMap<Expression, Expression>();
    private final Expression root;
    private final Deque<Expression> linearized;

    public LinearizedStringExpression(Expression expression) {
        this.root = expression;
        this.linearized = this.linearize(expression).collect(Collectors.toCollection(ArrayDeque::new));
    }

    public Deque<Expression> getLinearized() {
        return this.linearized;
    }

    public Expression getRoot() {
        return this.root;
    }

    public Map<Expression, Expression> getResolvedExpressionsMap() {
        return this.resolvedExpressions;
    }

    private Stream<Expression> linearize(Expression stringExpression) {
        return this.findLeaves(stringExpression);
    }

    private Stream<Expression> findLeaves(Expression e) {
        if (e instanceof EnclosedExpr) {
            if (LinearizedStringExpression.calculateResolvedType(e).filter(rt -> rt.describe().equals("java.lang.String")).isPresent()) {
                return this.findLeaves(e.asEnclosedExpr().getInner());
            }
            return Stream.of(e);
        }
        if (e instanceof BinaryExpr && e.asBinaryExpr().getOperator().equals((Object)BinaryExpr.Operator.PLUS)) {
            Stream<Expression> left = this.findLeaves(e.asBinaryExpr().getLeft());
            Stream<Expression> right = this.findLeaves(e.asBinaryExpr().getRight());
            return Stream.concat(left, right);
        }
        if (e instanceof NameExpr && LinearizedStringExpression.calculateResolvedType(e).filter(rt -> rt.describe().equals("java.lang.String")).isPresent()) {
            Expression resolved = this.resolveLocalExpressionEmptyString(e);
            if (resolved != e) {
                return this.findLeaves(resolved);
            }
            return Stream.of(e);
        }
        return Stream.of(e);
    }

    private static Optional<ResolvedType> calculateResolvedType(Expression e) {
        try {
            return Optional.of(e.calculateResolvedType());
        }
        catch (RuntimeException exception) {
            return Optional.empty();
        }
    }

    private Expression resolveLocalExpressionEmptyString(Expression expr) {
        Optional<LocalVariableDeclaration> maybelvd = Optional.of(expr).map(e -> e instanceof NameExpr ? e.asNameExpr() : null).flatMap(n -> ASTs.findEarliestLocalDeclarationOf(n.getName())).map(s -> s instanceof LocalVariableDeclaration ? (LocalVariableDeclaration)s : null);
        List first2Assignments = maybelvd.stream().flatMap(ASTs::findAllAssignments).limit(2L).toList();
        Optional<Object> maybeInit = maybelvd.flatMap(lvd -> lvd.getVariableDeclarator().getInitializer());
        if (maybeInit.isPresent() && first2Assignments.isEmpty()) {
            this.resolvedExpressions.put((Expression)maybeInit.get(), expr);
            return maybeInit.map(this::resolveLocalExpressionEmptyString).get();
        }
        if ((maybeInit.isPresent() && maybeInit.map(e -> e.isStringLiteralExpr() ? e.asStringLiteralExpr() : null).filter(sle -> Objects.equals(sle.asString(), "")).isPresent() || maybeInit.isEmpty()) && first2Assignments.size() == 1) {
            this.resolvedExpressions.put(((AssignExpr)first2Assignments.get(0)).getValue(), expr);
            return this.resolveLocalExpressionEmptyString(((AssignExpr)first2Assignments.get(0)).getValue());
        }
        return expr;
    }
}

