/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.TryStmt;
import io.codemodder.ast.ASTs;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class LocalScope {
    NodeList<Expression> expressions;
    NodeList<Statement> statements;

    private LocalScope(NodeList<Expression> expressions, NodeList<Statement> statements) {
        this.expressions = expressions;
        this.statements = statements;
    }

    public static LocalScope fromTryResource(TryStmt stmt, VariableDeclarator vd) {
        VariableDeclarationExpr vde = (VariableDeclarationExpr)vd.getParentNode().get();
        NodeList resources = stmt.getResources();
        NodeList expressions = new NodeList();
        expressions.setParentNode((Node)stmt);
        resources.stream().skip(resources.indexOf((Object)vde) + 1).forEach(arg_0 -> ((NodeList)expressions).add(arg_0));
        return new LocalScope((NodeList<Expression>)expressions, (NodeList<Statement>)stmt.getTryBlock().getStatements());
    }

    public static LocalScope fromLocalDeclaration(ExpressionStmt stmt, VariableDeclarator vd) {
        NodeList expressions = new NodeList();
        VariableDeclarationExpr vde = (VariableDeclarationExpr)vd.getParentNode().get();
        int vdIndex = vde.getVariables().indexOf((Object)vd);
        vde.getVariables().stream().skip(vdIndex + 1).map(VariableDeclarator::getInitializer).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((NodeList)expressions).add(arg_0));
        BlockStmt block = (BlockStmt)stmt.getParentNode().get();
        NodeList statements = new NodeList();
        statements.setParentNode((Node)block);
        block.getStatements().stream().skip(block.getStatements().indexOf((Object)stmt) + 1).forEach(arg_0 -> ((NodeList)statements).add(arg_0));
        return new LocalScope((NodeList<Expression>)expressions, (NodeList<Statement>)statements);
    }

    public static LocalScope fromForEachDeclaration(ForEachStmt stmt) {
        NodeList statements;
        NodeList expressions = new NodeList();
        expressions.setParentNode((Node)stmt);
        Statement body = stmt.getBody();
        if (body instanceof BlockStmt) {
            statements = ((BlockStmt)body).getStatements();
        } else {
            statements = new NodeList();
            statements.setParentNode((Node)stmt);
        }
        return new LocalScope((NodeList<Expression>)expressions, (NodeList<Statement>)statements);
    }

    public static LocalScope fromForDeclaration(ForStmt stmt, VariableDeclarator vd) {
        NodeList statements;
        NodeList expressions = new NodeList();
        VariableDeclarationExpr vde = (VariableDeclarationExpr)stmt.getInitialization().get(0);
        int vdIndex = IntStream.range(0, vde.getVariables().size()).filter(i -> vde.getVariable(i).equals((Object)vd)).findFirst().getAsInt();
        vde.getVariables().stream().skip(vdIndex + 1).forEach(vdInVDE -> vdInVDE.getInitializer().ifPresent(arg_0 -> ((NodeList)expressions).add(arg_0)));
        if (stmt.getCompare().isPresent()) {
            expressions.add((Node)((Expression)stmt.getCompare().get()));
        }
        expressions.addAll(stmt.getUpdate());
        Statement body = stmt.getBody();
        if (body instanceof BlockStmt) {
            statements = ((BlockStmt)body).getStatements();
        } else {
            statements = new NodeList();
            statements.setParentNode((Node)stmt);
        }
        return new LocalScope((NodeList<Expression>)expressions, (NodeList<Statement>)statements);
    }

    public static LocalScope fromParameter(Parameter parameter) {
        Node parent = (Node)parameter.getParentNode().get();
        NodeList statements = new NodeList();
        NodeList expressions = new NodeList();
        if (parent instanceof LambdaExpr) {
            Stream<Statement> allStatements = Stream.of(((LambdaExpr)parent).getBody());
            allStatements.flatMap(s -> s.isBlockStmt() ? s.asBlockStmt().getStatements().stream() : Stream.of(s)).forEach(arg_0 -> ((NodeList)statements).add(arg_0));
        }
        if (parent instanceof MethodDeclaration) {
            Optional maybeBody = ((MethodDeclaration)parent).getBody();
            statements = maybeBody.map(bs -> bs.getStatements()).orElse(statements);
        }
        if (parent instanceof CatchClause) {
            statements = ((CatchClause)parent).getBody().getStatements();
        }
        if (parent instanceof ConstructorDeclaration) {
            statements = ((ConstructorDeclaration)parent).getBody().getStatements();
        }
        return new LocalScope((NodeList<Expression>)expressions, (NodeList<Statement>)statements);
    }

    public static LocalScope fromAssignExpression(AssignExpr aexpr) {
        NodeList expressions = new NodeList();
        NodeList statements = new NodeList();
        Optional<ExpressionStmt> maybeStmt = ASTs.isExpressionStmtExpr((Expression)aexpr);
        if (maybeStmt.isPresent()) {
            BlockStmt block = (BlockStmt)maybeStmt.get().getParentNode().get();
            statements.setParentNode((Node)block);
            block.getStatements().stream().skip(block.getStatements().indexOf((Object)maybeStmt.get()) + 1).forEach(arg_0 -> ((NodeList)statements).add(arg_0));
        }
        return new LocalScope((NodeList<Expression>)expressions, (NodeList<Statement>)statements);
    }

    public NodeList<Expression> getExpressions() {
        return this.expressions;
    }

    public NodeList<Statement> getStatements() {
        return this.statements;
    }

    public Stream<Node> stream() {
        return Stream.concat(this.expressions.stream(), this.statements.stream());
    }

    public boolean inScope(Node n) {
        Node scopeStatementsRoot = (Node)this.statements.getParentNode().get();
        for (Expression e : this.expressions) {
            if (!n.equals((Object)e) && !e.isAncestorOf(n)) continue;
            return true;
        }
        for (Statement s : this.statements) {
            if (!n.equals((Object)s) && !s.isAncestorOf(n)) continue;
            return true;
        }
        return false;
    }
}

