/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation;

import io.codemodder.DependencyGAV;
import io.codemodder.Either;
import io.codemodder.remediation.SuccessOrReason;
import java.util.List;
import java.util.NoSuchElementException;

class DefaultSuccessOrReason
implements SuccessOrReason {
    private final Either<List<DependencyGAV>, String> either;

    DefaultSuccessOrReason(List<DependencyGAV> dependencies) {
        this.either = Either.left(dependencies);
    }

    DefaultSuccessOrReason(String reason) {
        this.either = Either.right(reason);
    }

    @Override
    public boolean isSuccess() {
        return this.either.isLeft();
    }

    @Override
    public List<DependencyGAV> getDependencies() {
        if (!this.isSuccess()) {
            throw new NoSuchElementException("Trying to get dependencies from a failure result");
        }
        return this.either.getLeft();
    }

    @Override
    public String getReason() {
        if (this.isSuccess()) {
            throw new NoSuchElementException("Trying to get a reason from a successful result");
        }
        return this.either.getRight();
    }
}

