/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.headerinjection;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import java.util.Optional;

public final class HeaderInjectionFixStrategy
implements RemediationStrategy {
    private static final String validatorMethodName = "stripNewlines";
    private static final String fixMethodCode = "private static String stripNewlines(final String s) {\n  return s.replaceAll(\"[\\n\\r]\", \"\");\n}\n";

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional<MethodCallExpr> maybeMethodCall = Optional.of(node).map(n -> n instanceof MethodCallExpr ? (MethodCallExpr)n : null);
        if (maybeMethodCall.isEmpty()) {
            return SuccessOrReason.reason("Not a method call");
        }
        MethodCallExpr setHeaderCall = maybeMethodCall.get();
        Expression headerValueArgument = setHeaderCall.getArgument(1);
        JavaParserTransformer.wrap(headerValueArgument).withScopelessMethod(validatorMethodName);
        Optional maybeParentClass = setHeaderCall.findAncestor(new Class[]{ClassOrInterfaceDeclaration.class});
        if (maybeParentClass.isEmpty()) {
            return SuccessOrReason.reason("Could not find parent class");
        }
        ClassOrInterfaceDeclaration parentClass = (ClassOrInterfaceDeclaration)maybeParentClass.get();
        if (parentClass.isInterface()) {
            MethodCallExpr inlinedStripCall = new MethodCallExpr(headerValueArgument, "replaceAll", NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr("[\\n\\r]"), new StringLiteralExpr("")}));
            setHeaderCall.getArguments().set(1, (Node)inlinedStripCall);
        } else {
            boolean alreadyHasResourceValidationCallPresent = parentClass.findAll(MethodDeclaration.class).stream().anyMatch(md -> md.getNameAsString().equals(validatorMethodName) && md.getParameters().size() == 1 && ((Parameter)md.getParameters().get(0)).getTypeAsString().equals("String"));
            if (!alreadyHasResourceValidationCallPresent) {
                MethodDeclaration fixMethod = StaticJavaParser.parseMethodDeclaration((String)fixMethodCode);
                parentClass.addMember((BodyDeclaration)fixMethod);
            }
        }
        return SuccessOrReason.success();
    }
}

