/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.jndiinjection;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import io.codemodder.DependencyGAV;
import io.codemodder.Either;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.codemodder.remediation.jndiinjection.JNDIFixContext;
import io.github.pixee.security.JNDI;
import java.util.List;

public final class ReplaceLimitedLookupStrategy
implements RemediationStrategy {
    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Either<JNDIFixContext, String> contextOrReason = JNDIFixContext.fromNode(node);
        if (contextOrReason.isRight()) {
            return SuccessOrReason.reason(contextOrReason.getRight());
        }
        JNDIFixContext context = contextOrReason.getLeft();
        String className = JNDI.class.getName();
        String methodName = "limitedContext";
        Expression jndiContext = (Expression)context.lookupCall().getScope().get();
        JavaParserTransformer.wrap(jndiContext).withStaticMethod(className, methodName, false);
        return SuccessOrReason.success(List.of(DependencyGAV.JAVA_SECURITY_TOOLKIT));
    }
}

