/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.resourceleak;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VarType;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.types.ResolvedType;
import io.codemodder.Either;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.ast.ASTs;
import io.codemodder.ast.ExpressionStmtVariableDeclaration;
import io.codemodder.ast.LocalDeclaration;
import io.codemodder.ast.LocalScope;
import io.codemodder.ast.LocalVariableDeclaration;
import io.codemodder.ast.ParameterDeclaration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceLeakFixer {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceLeakFixer.class);
    private static final String rootPrefix = "resource";
    private static Set<String> initMethodsList = Set.of("newBufferedReader", "newBufferedWriter", "newByteChannel", "newDirectoryStream", "newInputStream", "newOutputStream");

    private ResourceLeakFixer() {
    }

    public static Optional<TryStmt> checkAndFix(Expression expr) {
        ObjectCreationExpr root;
        if (expr instanceof ObjectCreationExpr && ResourceLeakFixer.isFixable((Expression)(root = ResourceLeakFixer.findRootExpression(expr.asObjectCreationExpr())))) {
            Optional<TryStmt> maybeFixed = ResourceLeakFixer.tryToFix(root);
            return maybeFixed.flatMap(ts -> ASTTransforms.mergeStackedTryStmts(ts)).or(() -> maybeFixed);
        }
        if (expr instanceof MethodCallExpr && ResourceLeakFixer.isFixable(expr)) {
            Optional<TryStmt> maybeFixed = ResourceLeakFixer.tryToFix(expr.asMethodCallExpr());
            return maybeFixed.flatMap(ts -> ASTTransforms.mergeStackedTryStmts(ts)).or(() -> maybeFixed);
        }
        return Optional.empty();
    }

    public static boolean isFixable(Expression expr) {
        if (!ResourceLeakFixer.isAutoCloseableType(expr)) {
            return false;
        }
        if (ResourceLeakFixer.isClosedOrEscapes(expr)) {
            return false;
        }
        try {
            MethodCallExpr mce;
            if (expr instanceof MethodCallExpr && (mce = expr.asMethodCallExpr()).calculateResolvedType().describe().equals("java.sql.ResultSet")) {
                Optional<LocalVariableDeclaration> maybeLVD;
                Expression mceScope = (Expression)mce.getScope().get();
                if (mceScope.isFieldAccessExpr()) {
                    return false;
                }
                if (mceScope.isNameExpr() && (maybeLVD = ASTs.findEarliestLocalVariableDeclarationOf((Node)mceScope, mceScope.asNameExpr().getNameAsString())).filter(lvd -> ResourceLeakFixer.escapesRootScope(lvd, (Node n) -> true)).isPresent()) {
                    return false;
                }
            }
        }
        catch (UnsolvedSymbolException e2) {
            LOG.error("Problem resolving type of : {}", (Object)expr, (Object)e2);
            return false;
        }
        Optional<LocalVariableDeclaration> maybeLVD = ResourceLeakFixer.immediatelyFlowsIntoLocalVariable(expr);
        if (maybeLVD.isPresent()) {
            LocalScope scope = maybeLVD.get().getScope();
            Predicate<Node> isInScope = scope::inScope;
            List<Expression> allDependent = ResourceLeakFixer.findDependentResources(expr);
            return allDependent.stream().noneMatch(e -> ResourceLeakFixer.escapesRootScope(e, isInScope));
        }
        List<Expression> allDependent = ResourceLeakFixer.findDependentResources(expr);
        return allDependent.stream().noneMatch(e -> ResourceLeakFixer.escapesRootScope(e, (Node n) -> true));
    }

    private static boolean isClosedOrEscapes(Expression expr) {
        if (ResourceLeakFixer.immediatelyEscapesMethodScope(expr)) {
            return true;
        }
        List<Either<LocalDeclaration, Node>> allVariables = ResourceLeakFixer.flowsInto(expr);
        if (allVariables.stream().anyMatch(Either::isRight)) {
            return true;
        }
        if (allVariables.stream().filter(Either::isLeft).map(Either::getLeft).anyMatch(ld -> !ResourceLeakFixer.notClosed(ld))) {
            return true;
        }
        return allVariables.stream().filter(Either::isLeft).map(Either::getLeft).anyMatch(ld -> ResourceLeakFixer.escapesRootScope(ld, (Node x) -> true));
    }

    public static ObjectCreationExpr findRootExpression(ObjectCreationExpr creationExpr) {
        ObjectCreationExpr current = creationExpr;
        Optional<ObjectCreationExpr> maybeInner = Optional.of(current);
        while (maybeInner.isPresent()) {
            current = maybeInner.get();
            maybeInner = ASTs.isArgumentOfObjectCreationExpression((Expression)current).filter(ResourceLeakFixer::isAutoCloseableType);
        }
        return current;
    }

    private static String generateNameWithSuffix(Expression start) {
        Object root = rootPrefix;
        try {
            Object typeName = start.calculateResolvedType().describe();
            typeName = ((String)typeName).substring(((String)typeName).lastIndexOf(46) + 1);
            root = typeName = Character.toLowerCase(((String)typeName).charAt(0)) + ((String)typeName).substring(1);
        }
        catch (RuntimeException e) {
            root = rootPrefix;
        }
        Optional<Node> maybeName = ASTs.findNonCallableSimpleNameSource((Node)start, (String)root);
        int count = 0;
        Object nameWithSuffix = root;
        while (maybeName.isPresent()) {
            nameWithSuffix = (String)root + ++count;
            maybeName = ASTs.findNonCallableSimpleNameSource((Node)start, (String)nameWithSuffix);
        }
        return count == 0 ? root : nameWithSuffix;
    }

    public static Optional<TryStmt> tryToFix(ObjectCreationExpr creationExpr) {
        Deque<Expression> deque = ResourceLeakFixer.findInnerExpressions(creationExpr);
        Optional<ExpressionStmtVariableDeclaration> maybeLVD = ASTs.isInitExpr((Expression)creationExpr).flatMap(LocalVariableDeclaration::fromVariableDeclarator).map(lvd -> lvd instanceof ExpressionStmtVariableDeclaration ? (ExpressionStmtVariableDeclaration)lvd : null).filter(ASTs::isFinalOrNeverAssigned);
        if (maybeLVD.isPresent()) {
            TryStmt tryStmt = ASTTransforms.wrapIntoResource(maybeLVD.get().getStatement(), maybeLVD.get().getVariableDeclarationExpr(), maybeLVD.get().getScope());
            CompilationUnit cu = (CompilationUnit)creationExpr.findCompilationUnit().get();
            for (Expression resource : deque) {
                Optional<String> typeName = ResourceLeakFixer.calculateResolvedType(resource).map(rt -> rt.describe());
                tryStmt.getResources().addFirst((Node)new VariableDeclarationExpr(ResourceLeakFixer.buildDeclaration(resource, typeName)));
                typeName.ifPresent(tn -> ASTTransforms.addImportIfMissing(cu, tn));
            }
            return Optional.of(tryStmt);
        }
        return Optional.empty();
    }

    public static Optional<TryStmt> tryToFix(MethodCallExpr mce) {
        ArrayList<Expression> resources = new ArrayList<Expression>();
        Expression root = ResourceLeakFixer.findRootExpression((Expression)mce, resources);
        Optional<ExpressionStmtVariableDeclaration> maybeLVD = ASTs.isInitExpr(root).flatMap(LocalVariableDeclaration::fromVariableDeclarator).map(lvd -> lvd instanceof ExpressionStmtVariableDeclaration ? (ExpressionStmtVariableDeclaration)lvd : null).filter(ASTs::isFinalOrNeverAssigned);
        if (maybeLVD.isPresent()) {
            ExpressionStmtVariableDeclaration lvd2 = maybeLVD.get();
            TryStmt tryStmt = ASTTransforms.wrapIntoResource(lvd2.getStatement(), lvd2.getVariableDeclarationExpr(), lvd2.getScope());
            CompilationUnit cu = (CompilationUnit)mce.findCompilationUnit().get();
            for (Expression resource : resources) {
                Optional<String> typeName = ResourceLeakFixer.calculateResolvedType(resource).map(rt -> rt.describe());
                tryStmt.getResources().addFirst((Node)new VariableDeclarationExpr(ResourceLeakFixer.buildDeclaration(resource, typeName)));
                typeName.ifPresent(tn -> ASTTransforms.addImportIfMissing(cu, tn));
            }
            return Optional.of(tryStmt);
        }
        return Optional.empty();
    }

    private static Optional<ResolvedType> calculateResolvedType(Expression e) {
        try {
            return Optional.of(e.calculateResolvedType());
        }
        catch (RuntimeException exception) {
            return Optional.empty();
        }
    }

    private static VariableDeclarator buildDeclaration(Expression resource, Optional<String> typeName) {
        String name = ResourceLeakFixer.generateNameWithSuffix(resource);
        resource.replace((Node)new NameExpr(name));
        return new VariableDeclarator((Type)(typeName.isPresent() ? StaticJavaParser.parseType((String)typeName.get().substring(typeName.get().lastIndexOf(46) + 1)) : new VarType()), name, resource);
    }

    private static Deque<Expression> findInnerExpressions(ObjectCreationExpr creationExpr) {
        ArrayDeque<Expression> deque = new ArrayDeque<Expression>();
        Optional maybeExpr = creationExpr.getArguments().stream().flatMap(expr -> ResourceLeakFixer.isAutoCloseableCreation(expr).stream()).findFirst();
        while (maybeExpr.isPresent()) {
            deque.addLast((Expression)maybeExpr.get());
            maybeExpr = ((ObjectCreationExpr)maybeExpr.get()).getArguments().stream().flatMap(expr -> ResourceLeakFixer.isAutoCloseableCreation(expr).stream()).findFirst();
        }
        return deque;
    }

    private static Expression findRootExpression(Expression expr, List<Expression> resources) {
        Optional<MethodCallExpr> maybeCall = ASTs.isScopeInMethodCall(expr).filter(ResourceLeakFixer::isJDBCResourceInit);
        if (maybeCall.isPresent()) {
            resources.add(expr);
            return ResourceLeakFixer.findRootExpression((Expression)maybeCall.get(), resources);
        }
        return expr;
    }

    private static Optional<LocalVariableDeclaration> immediatelyFlowsIntoLocalVariable(Expression expr) {
        Optional<VariableDeclarator> maybeInit = ASTs.isInitExpr(expr).filter(ASTs::isLocalVariableDeclarator);
        if (maybeInit.isPresent()) {
            return maybeInit.flatMap(LocalVariableDeclaration::fromVariableDeclarator);
        }
        return ASTs.isAssigned(expr).map(ae -> ae.getTarget().isNameExpr() ? ae.getTarget().asNameExpr() : null).flatMap(ne -> ASTs.findEarliestLocalVariableDeclarationOf((Node)ne, ne.getNameAsString()));
    }

    private static boolean isAutoCloseableType(Expression expr) {
        try {
            return expr.calculateResolvedType().isReferenceType() && expr.calculateResolvedType().asReferenceType().getAllAncestors().stream().anyMatch(t -> t.describe().equals("java.lang.AutoCloseable"));
        }
        catch (RuntimeException e) {
            LOG.error("Problem resolving type of : {}", (Object)expr);
            return false;
        }
    }

    private static Optional<ObjectCreationExpr> isAutoCloseableCreation(Expression expr) {
        return Optional.of(expr).filter(Expression::isObjectCreationExpr).map(Expression::asObjectCreationExpr).filter(oce -> ResourceLeakFixer.isAutoCloseableType(expr));
    }

    private static boolean isResourceInit(Expression expr) {
        return expr.isMethodCallExpr() && (ResourceLeakFixer.isJDBCResourceInit(expr.asMethodCallExpr()) || ResourceLeakFixer.isFilesResourceInit(expr.asMethodCallExpr())) || ResourceLeakFixer.isAutoCloseableCreation(expr).isPresent();
    }

    private static Either<LocalDeclaration, Node> isLocalDeclaration(Node n) {
        if (n instanceof VariableDeclarator) {
            Optional<LocalVariableDeclaration> maybe = LocalVariableDeclaration.fromVariableDeclarator((VariableDeclarator)n);
            return maybe.map(Either::left).orElseGet(() -> Either.right(n));
        }
        if (n instanceof Parameter) {
            return Either.left(new ParameterDeclaration((Parameter)n));
        }
        return Either.right(n);
    }

    private static boolean isFilesResourceInit(MethodCallExpr expr) {
        try {
            Optional<String> hasFilesScope = expr.getScope().map(mce -> mce.calculateResolvedType().describe()).filter("java.nio.file.Files"::equals);
            return hasFilesScope.isPresent() && initMethodsList.contains(expr.getNameAsString());
        }
        catch (UnsolvedSymbolException e) {
            LOG.error("Problem resolving type of : {}", (Object)expr, (Object)e);
            return false;
        }
    }

    private static boolean isJDBCResourceInit(MethodCallExpr expr) {
        Predicate<MethodCallExpr> isResultSetGen = mce -> switch (mce.getNameAsString()) {
            case "executeQuery", "getResultSet", "getGeneratedKeys" -> true;
            default -> false;
        };
        Predicate<MethodCallExpr> isStatementGen = mce -> switch (mce.getNameAsString()) {
            case "createStatement", "prepareCall", "prepareStatement" -> true;
            default -> false;
        };
        Predicate<MethodCallExpr> isReaderGen = mce -> switch (mce.getNameAsString()) {
            case "getCharacterStream", "getNCharacterStream" -> true;
            default -> false;
        };
        Predicate<MethodCallExpr> isDependent = isResultSetGen.or(isStatementGen.or(isReaderGen));
        return isDependent.test(expr);
    }

    private static List<Either<LocalDeclaration, Node>> flowsInto(Expression expr) {
        Optional<Either> maybeExpr = ASTs.isInitExpr(expr).flatMap(LocalVariableDeclaration::fromVariableDeclarator).map(Either::left);
        maybeExpr = maybeExpr.or(() -> ASTs.isAssigned(expr).filter(ae -> ae.getTarget().isNameExpr()).map(ae -> ae.getTarget().asNameExpr()).flatMap(ne -> ASTs.findNonCallableSimpleNameSource(ne.getName())).map(ResourceLeakFixer::isLocalDeclaration));
        return maybeExpr.map(e -> e.ifLeftOrElseGet(ResourceLeakFixer::flowsInto, n -> List.of(e))).orElse(List.of());
    }

    public static List<Either<LocalDeclaration, Node>> flowsInto(LocalDeclaration ld) {
        return ResourceLeakFixer.flowsIntoImpl(ld, new HashSet<Node>());
    }

    private static List<Either<LocalDeclaration, Node>> flowsIntoImpl(LocalDeclaration ld, HashSet<Node> memory) {
        if (memory.contains(ld.getDeclaration())) {
            return List.of();
        }
        memory.add(ld.getDeclaration());
        Predicate<AssignExpr> isRHSOfAE = ae -> ae.getValue().isNameExpr() && ASTs.findNonCallableSimpleNameSource(ae.getValue().asNameExpr().getName()).filter(n -> n == ld.getDeclaration()).isPresent();
        Stream<Expression> allAETarget = ld.getScope().stream().flatMap(n -> n.findAll(AssignExpr.class, isRHSOfAE).stream()).map(AssignExpr::getTarget);
        allAETarget = allAETarget.filter(e -> !e.isNameExpr() || !e.asNameExpr().getNameAsString().equals(ld.getName()));
        Stream fromAssignments = allAETarget.flatMap(e -> e.isNameExpr() ? ASTs.findEarliestLocalDeclarationOf(e.asNameExpr().getName()).map(decl -> ResourceLeakFixer.flowsIntoImpl(decl, memory).stream()).orElse(Stream.of(Either.right(e))) : Stream.of(Either.right(e)));
        Predicate<VariableDeclarator> isRHSOfVD = varDecl -> varDecl.getInitializer().filter(init -> init.isNameExpr() && ASTs.findNonCallableSimpleNameSource(init.asNameExpr().getName()).filter(n -> n == ld.getDeclaration()).isPresent()).isPresent();
        Stream allLVD = ld.getScope().stream().flatMap(n -> n.findAll(VariableDeclarator.class, isRHSOfVD).stream()).flatMap(vd -> LocalVariableDeclaration.fromVariableDeclarator(vd).stream());
        Stream fromInit = allLVD.flatMap(lvd -> ResourceLeakFixer.flowsIntoImpl(lvd, memory).stream());
        return Stream.concat(Stream.of(Either.left(ld)), Stream.concat(fromAssignments, fromInit)).toList();
    }

    private static List<Expression> findDirectlyDependentResources(LocalDeclaration ld) {
        Stream<MethodCallExpr> jdbcResources = ld.findAllMethodCalls().filter(ResourceLeakFixer::isJDBCResourceInit);
        Predicate<ObjectCreationExpr> wrapsLD = oce -> oce.getArguments().getFirst().filter(arg -> arg.isNameExpr() && ld.isReference(arg.asNameExpr())).isPresent();
        Stream<ObjectCreationExpr> oceResources = ld.getScope().stream().flatMap(n -> n.findAll(ObjectCreationExpr.class).stream()).filter(wrapsLD);
        return Stream.concat(jdbcResources, oceResources).collect(Collectors.toList());
    }

    public static Optional<Expression> findResourceInit(NameExpr name) {
        Object u;
        Optional maybeResourceInit = ASTs.findEarliestLocalVariableDeclarationOf((Node)name, name.getNameAsString()).filter(ASTs::isFinalOrNeverAssigned).flatMap(lvd -> lvd.getVariableDeclarator().getInitializer());
        if (maybeResourceInit.isPresent() && (u = maybeResourceInit.get()) instanceof NameExpr) {
            NameExpr ne = (NameExpr)u;
            return ResourceLeakFixer.findResourceInit(ne);
        }
        return maybeResourceInit.filter(ResourceLeakFixer::isResourceInit);
    }

    private static List<Expression> findDirectlyDependentResources(Expression expr) {
        Optional<ObjectCreationExpr> maybeOCE;
        ArrayList<Expression> allDependent = new ArrayList<Expression>();
        Optional<MethodCallExpr> maybeMCE = ASTs.isScopeInMethodCall(expr).filter(ResourceLeakFixer::isJDBCResourceInit);
        if (maybeMCE.isPresent()) {
            allDependent.add((Expression)maybeMCE.get());
            return allDependent;
        }
        if (expr instanceof ObjectCreationExpr) {
            Optional<Expression> maybeArg = expr.asObjectCreationExpr().getArguments().stream().filter(ResourceLeakFixer::isAutoCloseableType).findFirst();
            Optional maybeResourceInit = maybeArg.filter(Expression::isNameExpr).flatMap(e -> ResourceLeakFixer.findResourceInit(e.asNameExpr()));
            if (maybeResourceInit.isPresent()) {
                maybeResourceInit.ifPresent(allDependent::add);
            } else {
                maybeArg.ifPresent(allDependent::add);
            }
        }
        if ((maybeOCE = ASTs.isConstructorArgument(expr).filter(ResourceLeakFixer::isAutoCloseableType)).isPresent()) {
            allDependent.add((Expression)maybeOCE.get());
            return allDependent;
        }
        Stream<LocalDeclaration> allFlown = ResourceLeakFixer.flowsInto(expr).stream().filter(Either::isLeft).map(Either::getLeft);
        allFlown.flatMap(ld -> ResourceLeakFixer.findDirectlyDependentResources(ld).stream()).forEach(allDependent::add);
        return allDependent;
    }

    private static List<Expression> findDependentResources(Expression expr) {
        HashSet<Node> memory = new HashSet<Node>();
        return ResourceLeakFixer.findDependentResourcesImpl(expr, memory);
    }

    private static List<Expression> findDependentResourcesImpl(Expression expr, HashSet<Node> memory) {
        if (memory.contains(expr)) {
            return List.of();
        }
        memory.add((Node)expr);
        return ResourceLeakFixer.findDirectlyDependentResources(expr).stream().filter(res -> !memory.contains(res)).flatMap(res -> Stream.concat(Stream.of(res), ResourceLeakFixer.findDependentResourcesImpl(res, memory).stream())).toList();
    }

    private static boolean immediatelyEscapesMethodScope(Expression expr) {
        if (!ResourceLeakFixer.isResourceInit(expr)) {
            return true;
        }
        if (ASTs.isReturnExpr(expr).isPresent() || ASTs.isArgumentOfMethodCall(expr).isPresent()) {
            return true;
        }
        return ASTs.isInitExpr(expr).flatMap(ASTs::isVariableOfField).isPresent();
    }

    private static boolean notClosed(LocalDeclaration ld) {
        return ld.findAllMethodCalls().noneMatch(mce -> mce.getNameAsString().equals("close")) && ld instanceof LocalVariableDeclaration && ASTs.isResource(((LocalVariableDeclaration)ld).getVariableDeclarator()).isEmpty();
    }

    private static boolean escapesRootScope(LocalDeclaration ld, Predicate<Node> isInScope) {
        if (!isInScope.test(ld.getDeclaration())) {
            return true;
        }
        return ld.findAllReferences().anyMatch(ne -> ASTs.isReturnExpr((Expression)ne).isPresent() || ASTs.isArgumentOfMethodCall((Expression)ne).isPresent());
    }

    private static boolean escapesRootScope(Expression expr, Predicate<Node> isInScope) {
        if (ResourceLeakFixer.immediatelyEscapesMethodScope(expr)) {
            return true;
        }
        List<Either<LocalDeclaration, Node>> allVariables = ResourceLeakFixer.flowsInto(expr);
        if (allVariables.stream().anyMatch(Either::isRight)) {
            return true;
        }
        return allVariables.stream().filter(Either::isLeft).map(Either::getLeft).anyMatch(ld -> ResourceLeakFixer.notClosed(ld) && ResourceLeakFixer.escapesRootScope(ld, isInScope));
    }
}

