/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xss;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.ReturnStmt;
import io.codemodder.DependencyGAV;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.VisibleForTesting;

final class NakedVariableReturnFixStrategy
implements RemediationStrategy {
    NakedVariableReturnFixStrategy() {
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional<ReturnStmt> maybeReturn = Optional.of(node).map(n -> n instanceof ReturnStmt ? (ReturnStmt)n : null);
        if (maybeReturn.isEmpty()) {
            return SuccessOrReason.reason("Not a return statement");
        }
        ReturnStmt nakedReturn = maybeReturn.get();
        JavaParserTransformer.wrap((Expression)nakedReturn.getExpression().get()).withStaticMethod("org.owasp.encoder.Encode", "forHtml", false);
        return SuccessOrReason.success(List.of(DependencyGAV.OWASP_XSS_JAVA_ENCODER));
    }

    @VisibleForTesting
    public static boolean match(Node node) {
        return Optional.of(node).map(n -> n instanceof ReturnStmt ? (ReturnStmt)n : null).filter(rs -> rs.getExpression().isPresent()).filter(rs -> ((Expression)rs.getExpression().get()).isNameExpr()).isPresent();
    }
}

