/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTs;
import io.codemodder.remediation.MatchAndFixStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.codemodder.remediation.xxe.XMLFixBuilder;
import java.util.Optional;
import java.util.Set;

final class XMLReaderAtParseFixStrategy
extends MatchAndFixStrategy {
    XMLReaderAtParseFixStrategy() {
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional<MethodCallExpr> maybeCall = Optional.of(node).map(n -> n instanceof MethodCallExpr ? (MethodCallExpr)n : null);
        if (maybeCall.isEmpty()) {
            return SuccessOrReason.reason("Not a method call.");
        }
        MethodCallExpr parseCall = maybeCall.get();
        Optional parserRef = parseCall.getScope();
        if (parserRef.isEmpty()) {
            return SuccessOrReason.reason("No scope found for parse() call");
        }
        if (!((Expression)parserRef.get()).isNameExpr()) {
            return SuccessOrReason.reason("Scope is not a name expression");
        }
        NameExpr parser = ((Expression)parserRef.get()).asNameExpr();
        Optional parseStatement = parseCall.findAncestor(new Class[]{Statement.class});
        if (parseStatement.isEmpty()) {
            return SuccessOrReason.reason("No statement found for parse() call");
        }
        return XMLFixBuilder.addFeatureDisablingStatements(parser.asNameExpr(), (Statement)parseStatement.get(), true);
    }

    @Override
    public boolean match(Node node) {
        return Optional.of(node).map(n -> n instanceof MethodCallExpr ? (MethodCallExpr)n : null).filter(m -> "parse".equals(m.getNameAsString())).filter(m -> m.getScope().isPresent()).filter(m -> ((Expression)m.getScope().get()).isNameExpr()).filter(m -> {
            Optional<Node> sourceRef = ASTs.findNonCallableSimpleNameSource(((Expression)m.getScope().get()).asNameExpr().getName());
            if (sourceRef.isEmpty()) {
                return false;
            }
            Node source = sourceRef.get();
            if (source instanceof NodeWithType) {
                return Set.of("XMLReader", "org.xml.sax.XMLReader").contains(((NodeWithType)source).getTypeAsString());
            }
            return false;
        }).isPresent();
    }
}

