/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.defectdojo;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import io.codemodder.CodeChanger;
import io.codemodder.providers.defectdojo.DefaultRuleFindings;
import io.codemodder.providers.defectdojo.DefectDojoScan;
import io.codemodder.providers.defectdojo.Finding;
import io.codemodder.providers.defectdojo.Findings;
import io.codemodder.providers.defectdojo.RuleFindings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

final class DefectDojoModule
extends AbstractModule {
    private final List<Class<? extends CodeChanger>> codemodTypes;
    private final Path defectDojoFindingsJsonFile;
    private final Path projectDir;

    DefectDojoModule(List<Class<? extends CodeChanger>> codemodTypes, Path projectDir, Path defectDojoFindingsJsonFile) {
        this.codemodTypes = Objects.requireNonNull(codemodTypes);
        this.projectDir = Objects.requireNonNull(projectDir);
        this.defectDojoFindingsJsonFile = defectDojoFindingsJsonFile;
    }

    protected void configure() {
        Findings findings;
        if (this.defectDojoFindingsJsonFile == null) {
            findings = new Findings(List.of());
        } else {
            try {
                findings = (Findings)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(this.defectDojoFindingsJsonFile.toFile(), Findings.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException("can't read defectdojo JSON", e);
            }
        }
        HashMap<String, List> ruleFindingsMap = new HashMap<String, List>();
        for (Finding finding : findings.getResults()) {
            String ruleId = finding.getVulnIdFromTool();
            List ruleFindings = ruleFindingsMap.computeIfAbsent(ruleId, k -> new ArrayList());
            ruleFindings.add(finding);
        }
        for (Class clazz : this.codemodTypes) {
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            Optional<DefectDojoScan> annotation = Stream.of(constructors).filter(constructor -> constructor.getAnnotation(Inject.class) != null).flatMap(constructor -> Stream.of(constructor.getParameters())).map(parameter -> parameter.getAnnotation(DefectDojoScan.class)).filter(Objects::nonNull).findFirst();
            annotation.ifPresent(defectDojoScan -> {
                List<Finding> ruleFindings = ruleFindingsMap.getOrDefault(defectDojoScan.ruleId(), List.of());
                DefaultRuleFindings ruleFindingsToBind = new DefaultRuleFindings(ruleFindings, this.projectDir);
                this.bind(RuleFindings.class).annotatedWith((Annotation)defectDojoScan).toInstance((Object)ruleFindingsToBind);
            });
        }
    }
}

