/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.testutils;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.Patch;
import io.codemodder.CodeChanger;
import io.codemodder.CodeDirectory;
import io.codemodder.CodemodExecutor;
import io.codemodder.CodemodExecutorFactory;
import io.codemodder.CodemodIdPair;
import io.codemodder.CodemodLoader;
import io.codemodder.CodemodRegulator;
import io.codemodder.DefaultRuleSetting;
import io.codemodder.DependencyGAV;
import io.codemodder.EncodingDetector;
import io.codemodder.FileCache;
import io.codemodder.IncludesExcludes;
import io.codemodder.ProjectProvider;
import io.codemodder.SarifParser;
import io.codemodder.SourceDirectory;
import io.codemodder.codetf.CodeTFChange;
import io.codemodder.codetf.CodeTFChangesetEntry;
import io.codemodder.codetf.CodeTFResult;
import io.codemodder.javaparser.JavaParserFacade;
import io.codemodder.javaparser.JavaParserFactory;
import io.codemodder.testutils.ExpectedFixes;
import io.codemodder.testutils.Metadata;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.jupiter.api.io.TempDir;

public interface CodemodTestMixin {
    @TestFactory
    default public Stream<DynamicTest> generateTestCases(@TempDir Path tmpDir) throws IOException {
        Metadata metadata = this.getClass().getAnnotation(Metadata.class);
        if (metadata == null) {
            throw new IllegalArgumentException("Test class must be annotated with @Metadata");
        }
        Path testResourceDir = Path.of("src/test/resources/", metadata.testResourceDir());
        Stream<Path> inputStream = Files.walk(testResourceDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".java.before"));
        Function<Path, String> displayNameGenerator = p -> p.toString().substring(testResourceDir.toString().length());
        List<DependencyGAV> dependencies = Arrays.stream(metadata.dependencies()).map(dependency -> {
            String[] tokens = dependency.split(":");
            return DependencyGAV.createDefault((String)tokens[0], (String)tokens[1], (String)tokens[2]);
        }).toList();
        List<ProjectProvider> projectProviders = Arrays.stream(metadata.projectProviders()).map(projectProvider -> {
            try {
                return (ProjectProvider)projectProvider.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }).toList();
        ThrowingConsumer testExecutor = path -> this.verifyCodemod(metadata.codemodType(), metadata.renameTestFile(), tmpDir, testResourceDir, (Path)path, dependencies, projectProviders, metadata.doRetransformTest(), metadata.expectingFixesAtLines(), metadata.expectingFailedFixesAtLines(), metadata.sonarIssuesJsonFiles(), metadata.sonarHotspotsJsonFiles());
        return DynamicTest.stream(inputStream, displayNameGenerator, (ThrowingConsumer)testExecutor);
    }

    private void verifyCodemod(Class<? extends CodeChanger> codemodType, String renameTestFile, Path tmpDir, Path testResourceDir, Path before, List<DependencyGAV> dependenciesExpected, List<ProjectProvider> projectProviders, boolean doRetransformTest, int[] expectedFixLines, int[] expectingFailedFixesAtLines, String[] sonarIssuesJsonFiles, String[] sonarHotspotsJsonFiles) throws IOException {
        Path after = before.resolveSibling(before.getFileName().toString().replace(".before", ".after"));
        Path pathToJavaFile = tmpDir.resolve("Test.java");
        Files.copy(before, pathToJavaFile, StandardCopyOption.REPLACE_EXISTING);
        if (!renameTestFile.isBlank()) {
            Path parent = tmpDir.resolve(renameTestFile).getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Path newPathToJavaFile = tmpDir.resolve(renameTestFile);
            Files.copy(pathToJavaFile, newPathToJavaFile, StandardCopyOption.REPLACE_EXISTING);
            pathToJavaFile = newPathToJavaFile;
        }
        List<Path> sonarIssuesJsonsPaths = this.buildSonarJsonPaths(testResourceDir, sonarIssuesJsonFiles, "sonar-issues.json");
        List<Path> sonarHotspotsJsonPaths = this.buildSonarJsonPaths(testResourceDir, sonarHotspotsJsonFiles, "sonar-hotspots.json");
        CodeDirectory codeDir = CodeDirectory.from((Path)tmpDir);
        ArrayList allSarifs = new ArrayList();
        Files.newDirectoryStream(testResourceDir, "*.sarif").iterator().forEachRemaining(allSarifs::add);
        Map map = SarifParser.create().parseIntoMap(allSarifs, codeDir);
        Path defectDojo = testResourceDir.resolve("defectdojo.json");
        Path contrastXml = testResourceDir.resolve("contrast.xml");
        CodemodLoader loader = new CodemodLoader(List.of(codemodType), CodemodRegulator.of((DefaultRuleSetting)DefaultRuleSetting.ENABLED, List.of()), tmpDir, List.of("**"), List.of(), List.of(pathToJavaFile), map, List.of(), sonarIssuesJsonsPaths, sonarHotspotsJsonPaths, Files.exists(defectDojo, new LinkOption[0]) ? defectDojo : null, Files.exists(contrastXml, new LinkOption[0]) ? contrastXml : null);
        List codemods = loader.getCodemods();
        MatcherAssert.assertThat((Object)codemods.size(), (Matcher)Matchers.equalTo((Object)1));
        CodemodIdPair codemod = (CodemodIdPair)codemods.get(0);
        JavaParserFactory factory = JavaParserFactory.newFactory();
        SourceDirectory dir = SourceDirectory.createDefault((Path)tmpDir, List.of(pathToJavaFile.toString()));
        CodemodExecutor executor = CodemodExecutorFactory.from(tmpDir, IncludesExcludes.any(), codemod, projectProviders, List.of(), FileCache.createDefault(), JavaParserFacade.from(() -> {
            try {
                return factory.create(List.of(dir));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), EncodingDetector.create());
        CodeTFResult result = executor.execute(List.of(pathToJavaFile));
        List changeset = result.getChangeset();
        MatcherAssert.assertThat((Object)result.getFailedFiles().size(), (Matcher)Matchers.equalTo((Object)0));
        if (Files.notExists(after, new LinkOption[0])) {
            MatcherAssert.assertThat((Object)result.getChangeset(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
            MatcherAssert.assertThat((Object)this.diff(before, pathToJavaFile).getDeltas(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
            return;
        }
        this.verifyTransformedCode(before, after, pathToJavaFile);
        MatcherAssert.assertThat((Object)changeset.size(), (Matcher)Matchers.is((Object)1));
        CodeTFChangesetEntry entry = (CodeTFChangesetEntry)changeset.get(0);
        MatcherAssert.assertThat((Object)entry.getChanges().isEmpty(), (Matcher)Matchers.is((Object)false));
        for (CodeTFChange change : ((CodeTFChangesetEntry)changeset.get(0)).getChanges()) {
            MatcherAssert.assertThat((Object)change.getLineNumber(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
            MatcherAssert.assertThat((Object)change.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.blankOrNullString())));
        }
        ExpectedFixes.verifyExpectedFixes(testResourceDir, result, codemod.getChanger(), expectedFixLines, expectingFailedFixesAtLines);
        MatcherAssert.assertThat((Object)result.getSummary(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.blankOrNullString())));
        MatcherAssert.assertThat((Object)result.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.blankOrNullString())));
        MatcherAssert.assertThat((Object)result.getReferences(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat(dependenciesExpected, (Matcher)Matchers.hasItems((Object[])dependenciesExpected.toArray(new DependencyGAV[0])));
        if (!doRetransformTest) {
            return;
        }
        String codeAfterFirstTransform = Files.readString(pathToJavaFile);
        CodemodLoader loader2 = new CodemodLoader(List.of(codemodType), CodemodRegulator.of((DefaultRuleSetting)DefaultRuleSetting.ENABLED, List.of()), tmpDir, List.of("**"), List.of(), List.of(pathToJavaFile), map, List.of(), null, null, null, null);
        CodemodIdPair codemod2 = (CodemodIdPair)loader2.getCodemods().get(0);
        CodemodExecutor executor2 = CodemodExecutorFactory.from(tmpDir, IncludesExcludes.any(), codemod2, projectProviders, List.of(), FileCache.createDefault(), JavaParserFacade.from(() -> {
            try {
                return factory.create(List.of(dir));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }), EncodingDetector.create());
        CodeTFResult result2 = executor2.execute(List.of(pathToJavaFile));
        List changeset2 = result2.getChangeset();
        MatcherAssert.assertThat((Object)changeset2.size(), (Matcher)Matchers.is((Object)0));
        String codeAfterSecondTransform = Files.readString(pathToJavaFile);
        MatcherAssert.assertThat((Object)codeAfterFirstTransform, (Matcher)Matchers.equalTo((Object)codeAfterSecondTransform));
    }

    private List<Path> buildSonarJsonPaths(Path testResourceDir, String[] sonarJsonFiles, String defaultSonarFilename) {
        Path defaultPath;
        ArrayList sonarJsons = sonarJsonFiles != null ? Arrays.asList(sonarJsonFiles) : new ArrayList();
        List<Path> sonarIssuesJsonsPaths = sonarJsons.stream().map(testResourceDir::resolve).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
        if (sonarIssuesJsonsPaths.isEmpty() && Files.exists(defaultPath = testResourceDir.resolve(defaultSonarFilename), new LinkOption[0])) {
            sonarIssuesJsonsPaths.add(defaultPath);
        }
        return sonarIssuesJsonsPaths;
    }

    default public void verifyTransformedCode(Path before, Path expected, Path after) throws IOException {
        String expectedCode = Files.readString(expected);
        String transformedJavaCode = Files.readString(after);
        MatcherAssert.assertThat((Object)transformedJavaCode, (Matcher)Matchers.equalTo((Object)expectedCode));
    }

    private Patch<String> diff(Path original, Path revised) throws IOException {
        return DiffUtils.diff(Files.readAllLines(original), Files.readAllLines(revised));
    }
}

