package io.contextmap.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * Annotation used to document an exemplar
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ContextExemplar {

    /**
     * Short title for the exemplar
     */
    String title();

    /**
     * Longer description about the exemplar
     */
    String description() default "";

    /**
     * List of tags associated with the exemplar.
     */
    String[] tags() default {};


}
