/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events.azure.eventhub;

import com.azure.spring.messaging.eventhubs.core.DefaultEventHubsNamespaceProducerFactory;
import com.azure.spring.messaging.eventhubs.core.EventHubsProducerFactory;
import com.azure.spring.messaging.eventhubs.core.EventHubsTemplate;
import com.azure.spring.messaging.eventhubs.core.properties.NamespaceProperties;
import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import io.contextmap.spring.runtime.scanner.events.EventFunctions;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.dispatcher.AbstractDispatcher;

public class AzureEventHubCloudStreamScanner
extends AbstractRuntimeScanner {
    private static final Logger logger = LoggerFactory.getLogger(AzureEventHubCloudStreamScanner.class);
    private final ScanApplicationContext context;

    public AzureEventHubCloudStreamScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        Map<String, ?> bindingServiceBeans = this.context.getBeansOfType("org.springframework.cloud.stream.binding.BindingService");
        if (bindingServiceBeans.isEmpty()) {
            return;
        }
        logger.info("Scanning Azure EventHub events (Cloud Stream)");
        data.getExecution().setScannedPublishedEvents(true);
        data.getExecution().setScannedSubscribedEvents(true);
        for (Object bindingService : bindingServiceBeans.values()) {
            try {
                Set<Event> outputs = this.reflectOutputs((BindingService)bindingService);
                data.addPublishedEvents(outputs);
                Set<Event> inputs = this.reflectInputs((BindingService)bindingService);
                data.addSubscribedEvents(inputs);
            }
            catch (Throwable e) {
                logger.warn("Problem detected while scanning eventhub: {}", (Object)e.getMessage());
            }
        }
    }

    private Set<Event> reflectOutputs(BindingService bindingService) throws Exception {
        Field field = BindingService.class.getDeclaredField("producerBindings");
        field.setAccessible(true);
        Map producerBindings = (Map)field.get(bindingService);
        HashSet<Event> events = new HashSet<Event>();
        for (Binding binding : producerBindings.values()) {
            try {
                String eventHubName = binding.getName();
                String namespace = null;
                EventHubsTemplate eventHubsTemplate = null;
                if (!(binding instanceof DefaultBinding)) continue;
                DefaultBinding defaultBinding = (DefaultBinding)binding;
                field = DefaultBinding.class.getDeclaredField("target");
                field.setAccessible(true);
                Object target = field.get(defaultBinding);
                if (target instanceof DirectChannel) {
                    AbstractDispatcher unicastingDispatcher;
                    DirectChannel channel = (DirectChannel)target;
                    field = DirectChannel.class.getDeclaredField("dispatcher");
                    field.setAccessible(true);
                    Object dispatcher = field.get(channel);
                    if (dispatcher instanceof AbstractDispatcher && (unicastingDispatcher = (AbstractDispatcher)dispatcher).getHandlerCount() > 0) {
                        field = AbstractDispatcher.class.getDeclaredField("handlers");
                        field.setAccessible(true);
                        Set handlers = (Set)field.get(unicastingDispatcher);
                        Object handler = handlers.iterator().next();
                        field = handler.getClass().getDeclaredField("delegate");
                        field.setAccessible(true);
                        Object delegate = field.get(handler);
                        if (delegate != null) {
                            Optional<NamespaceProperties> props;
                            field = delegate.getClass().getDeclaredField("sendOperation");
                            field.setAccessible(true);
                            Object sendOperation = field.get(delegate);
                            if (sendOperation instanceof EventHubsTemplate && (props = this.getNameSpaceProperties(eventHubsTemplate = (EventHubsTemplate)sendOperation)).isPresent()) {
                                namespace = props.get().getNamespace();
                            }
                        }
                    }
                }
                String fullName = this.formatName(namespace, eventHubName);
                Event event = new Event(fullName, eventHubName);
                events.add(event);
                HashMap<String, Event> eventWrappedInMap = new HashMap<String, Event>();
                eventWrappedInMap.put(event.getName(), event);
                eventWrappedInMap.put(eventHubName, event);
                Map<Class<?>, Set<EventFunctions.PayloadExchangeProperties>> eventClassToPublishers = EventFunctions.getPayloadProperties(this.context, this::resolveNameFromPublishedByName);
                EventFunctions.addPayloadsToEvents(eventClassToPublishers, eventWrappedInMap);
                if (eventHubsTemplate == null) continue;
                this.addPropertiesToEventFromEventHubsTemplate(event, eventHubsTemplate, eventHubName);
            }
            catch (Throwable t) {
                logger.warn("Problem detected while scanning eventhub: {}", (Object)t.getMessage());
            }
        }
        return events;
    }

    private Set<Event> reflectInputs(BindingService bindingService) throws Exception {
        Field field = BindingService.class.getDeclaredField("consumerBindings");
        field.setAccessible(true);
        Map consumerBindings = (Map)field.get(bindingService);
        HashSet<Event> events = new HashSet<Event>();
        for (List bindings : consumerBindings.values()) {
            for (Binding binding : bindings) {
                try {
                    String eventHubName = binding.getName();
                    Object namespace = null;
                    if (!(binding instanceof DefaultBinding)) continue;
                    DefaultBinding defaultBinding = (DefaultBinding)binding;
                    logger.debug("input: {}", (Object)eventHubName);
                }
                catch (Throwable t) {
                    logger.warn("Problem detected while scanning eventhub: {}", (Object)t.getMessage());
                }
            }
        }
        return events;
    }

    private void addPropertiesToEventFromEventHubsTemplate(Event event, EventHubsTemplate serviceBusTemplate, String eventHubName) throws Exception {
        event.addPropertyIfValueNotBlank("Message Broker", "Azure EventHub");
        event.addPropertyIfValueNotBlank("EventHub Name", eventHubName);
        this.getNameSpaceProperties(serviceBusTemplate).ifPresent(props -> event.addPropertyIfValueNotBlank("Namespace", props.getNamespace()));
    }

    private Optional<NamespaceProperties> getNameSpaceProperties(EventHubsTemplate eventHubsTemplate) throws Exception {
        Field field = EventHubsTemplate.class.getDeclaredField("producerFactory");
        field.setAccessible(true);
        EventHubsProducerFactory eventHubsProducerFactory = (EventHubsProducerFactory)field.get(eventHubsTemplate);
        if (eventHubsProducerFactory instanceof DefaultEventHubsNamespaceProducerFactory) {
            DefaultEventHubsNamespaceProducerFactory d = (DefaultEventHubsNamespaceProducerFactory)eventHubsProducerFactory;
            field = DefaultEventHubsNamespaceProducerFactory.class.getDeclaredField("namespaceProperties");
            field.setAccessible(true);
            NamespaceProperties properties = (NamespaceProperties)field.get(d);
            return Optional.ofNullable(properties);
        }
        return Optional.empty();
    }

    private String formatName(String namespace, String serviceBusName) {
        return this.formatNamespace(namespace) + ":" + serviceBusName;
    }

    private String formatNamespace(String namespace) {
        if (namespace == null || namespace.trim().isEmpty()) {
            String defaultNS = this.context.getParameters().getDefaultAzureEventHubNamespace();
            if (defaultNS != null && !defaultNS.trim().isEmpty()) {
                return defaultNS;
            }
            return "/";
        }
        return namespace;
    }

    private String resolveNameFromPublishedByName(Class<?> eventClass, String publishedByName) {
        return this.context.resolveSpELStringValue(publishedByName);
    }
}

